<?php

if (!defined('BASE_DIR')) { exit(header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found', true)); }

$news_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$seo_title = '';
$seo_description = '';
$seo_keywords = '';
$canonical_url = '';

if ($news_id > 0) {
    $query = $mysqli->query("SELECT * FROM `".PREFIX."_news` WHERE `id` = '".$news_id."'");
    if ($query->num_rows) {
        $news_item = $query->fetch_assoc();
        
        $seo_title = htmlspecialchars($news_item['title']) . ' - Новости';
        $seo_description = substr(strip_tags($news_item['text']), 0, 160);
        $seo_keywords = 'новости, ' . htmlspecialchars($news_item['title']);
        $canonical_url = 'https://'.$_SERVER['HTTP_HOST'].'/news.php?id='.$news_id;
        
        $obEngine->addTitleHtml(htmlspecialchars($news_item['title']));
        
    } else {
        exit(header('Location: /news.php'));
    }
} else {
    $seo_title = 'Новости';
    $seo_description = 'Актуальные новости и последние обновления. Будьте в курсе всех событий.';
    $seo_keywords = 'новости, обновления, события, информация';
    $canonical_url = 'https://'.$_SERVER['HTTP_HOST'].'/news.php';
    
    $obEngine->addTitleHtml('Новости');
}

if (isset($_SESSION['user_id']) && isset($users_info['status']) && $users_info['status'] == 1) {
    if (isset($_POST['title'])) {
        $title = clear($_POST['title']);
        $text = clear($_POST['text']);
        
        $mysqli->query("INSERT INTO `".PREFIX."_news` 
                                      (                                      
                                       `time_add`,
                                       `title`,
                                       `text`                                                                                                          
                                      )
                                      VALUES
                                      (                                                                                                                                                          
                                       NOW(),
                                       '".$title."', 
                                       '".$text."'                                                                                                                          
                                      )");
        
        exit(header('Location: /news.php'));    
    }    
}
?>
<title><?php echo $seo_title; ?></title>
<meta name="description" content="<?php echo htmlspecialchars($seo_description); ?>">
<meta name="keywords" content="<?php echo htmlspecialchars($seo_keywords); ?>">
<link rel="canonical" href="<?php echo $canonical_url; ?>">
<meta property="og:title" content="<?php echo htmlspecialchars($seo_title); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($seo_description); ?>">
<meta property="og:type" content="<?php echo ($news_id > 0) ? 'article' : 'website'; ?>">
<meta property="og:url" content="<?php echo !empty($canonical_url) ? $canonical_url : 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']; ?>">
<?php if ($news_id > 0 && isset($news_item)): ?>
<meta property="article:published_time" content="<?php echo date('c', strtotime($news_item['time_add'])); ?>">
<?php endif; ?>

<div class="col-lg-8">
    <?php if ($news_id > 0 && isset($news_item)): ?>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/news.php">Новости</a></li>
                <li class="breadcrumb-item active"><?php echo htmlspecialchars($news_item['title']); ?></li>
            </ol>
        </nav>
        
        <article itemscope itemtype="https://schema.org/NewsArticle">
            <meta itemprop="datePublished" content="<?php echo date('c', strtotime($news_item['time_add'])); ?>">
            <meta itemprop="dateModified" content="<?php echo date('c', strtotime($news_item['time_add'])); ?>">
            
            <h1 itemprop="headline" class="page-title"><?php echo htmlspecialchars($news_item['title']); ?></h1>
            
            <div class="text-muted mb-3">
                <time datetime="<?php echo date('c', strtotime($news_item['time_add'])); ?>" itemprop="datePublished">
                    <?php echo date("d.m.Y в H:i", strtotime($news_item['time_add'])); ?>
                </time>
            </div>
            
            <div class="card mb-4">
                <div class="card-body" itemprop="articleBody">
                    <?php echo nl2br(htmlspecialchars($news_item['text'])); ?>
                </div>
            </div>
            
            <div class="mt-4 mb-4">
                <a href="/news.php" class="btn btn-secondary">← Вернуться к списку новостей</a>
            </div>
        </article>
        
    <?php else: ?>
        <h1 class="page-title">Новости</h1>
        
        <?php
        $query = $mysqli->query("SELECT * FROM `".PREFIX."_news` ORDER BY `time_add` DESC");
        if ($query->num_rows) {
            while ($res = $query->fetch_assoc()) {
                $news_url = '/news.php?id='.$res['id'];
                ?>
                <article class="card mb-4" itemscope itemtype="https://schema.org/NewsArticle">
                    <div class="card-body">
                        <meta itemprop="datePublished" content="<?php echo date('c', strtotime($res['time_add'])); ?>">
                        
                        <h2 class="card-title" itemprop="headline">
                            <a href="<?php echo $news_url; ?>" itemprop="url" class="text-decoration-none">
                                <b><?php echo htmlspecialchars($res['title']); ?></b>
                            </a>
                        </h2>
                        
                        <div class="text-muted mb-2">
                            <time datetime="<?php echo date('c', strtotime($res['time_add'])); ?>" itemprop="datePublished">
                                <?php echo date("d.m.Y", strtotime($res['time_add'])); ?>
                            </time>
                        </div>
                        
                        <div itemprop="description">
                            <?php 
                            $preview_text = strip_tags($res['text']);
                            if (mb_strlen($preview_text) > 200) {
                                $preview_text = mb_substr($preview_text, 0, 200) . '...';
                            }
                            echo nl2br(htmlspecialchars($preview_text)); 
                            ?>
                        </div>
                        
                        <div class="mt-3">
                            <a href="<?php echo $news_url; ?>" class="btn btn-sm btn-outline-primary" itemprop="url">
                                Читать далее
                            </a>
                        </div>
                    </div>
                </article>
                <?php
            }
        } else {
            ?>
            <div class="card mb-4">
                <div class="card-body">
                    <h2 class="card-title mb-0">Новостей нет</h2>
                </div>
            </div>
            <?php
        }
        
        if (isset($_SESSION['user_id']) && isset($users_info['status']) && $users_info['status'] == 1) {
            ?>
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title">Добавить новость</h3>
                    <form style="margin-top: 30px;" name="form1" action="?mode=add" method="post">
                        <div class="form-group">
                            <label><b style="color:red;">*</b> Заголовок:</label>
                            <input type="text" name="title" maxlength="200" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label><b style="color:red;">*</b> Новость:</label>
                            <textarea name="text" class="form-control" cols="40" rows="6" maxlength="10000" required></textarea>
                        </div>
                        <button class="btn btn-default" style="float:right;">Добавить</button>
                    </form>
                </div>
            </div>
            <?php
        }
        ?>
    <?php endif; ?>
</div>

<?php include 'module/user_menu.php'; ?>

<?php if ($news_id == 0): ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "name": "Новости",
  "description": "<?php echo htmlspecialchars($seo_description); ?>",
  "url": "<?php echo $canonical_url; ?>"
}
</script>
<?php endif; ?>

<?php if ($news_id > 0 && isset($news_item)): ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "headline": "<?php echo htmlspecialchars($news_item['title']); ?>",
  "description": "<?php echo htmlspecialchars(substr(strip_tags($news_item['text']), 0, 160)); ?>",
  "datePublished": "<?php echo date('c', strtotime($news_item['time_add'])); ?>",
  "dateModified": "<?php echo date('c', strtotime($news_item['time_add'])); ?>"
}
</script>
<?php endif; ?>