<?php
session_start();
$title = 'Админ панель';
require_once '../sys/db.php';
require_once '../sys/head.php';

if (!isset($_SESSION['login_attempts'])) {
    $_SESSION['login_attempts'] = 0;
}
if (!isset($_SESSION['block_time'])) {
    $_SESSION['block_time'] = 0;
}

if ($_SESSION['login_attempts'] >= 3 && (time() - $_SESSION['block_time']) < 900) {
    $remaining_time = 900 - (time() - $_SESSION['block_time']);
    die('<div class="alert alert-danger">Доступ заблокирован. Попробуйте снова через ' . gmdate("i:s", $remaining_time) . ' минут.</div>');
}

$query = "SELECT * FROM `sett` LIMIT 1";
$result = $mysqli->query($query);
if ($result) {
    $set = $result->fetch_assoc();
} else {
    die('Ошибка при получении настроек: ' . $mysqli->error);
}

if (!isset($_SESSION['view']['captcha'])) {
    include 'captcha/captcha-st/captcha.php';
}

if (isset($_POST['ok'])) {
    $error = '';
    $adm = htmlspecialchars(trim($_POST['adm']));
    $pass = $_POST['pass'];
    $captcha = htmlspecialchars(trim($_POST['captcha']));


    if ($_SESSION['view']['captcha'] != $captcha) {
        echo '<div class="alert alert-danger">Неверная капча!</div>';
        include 'captcha/captcha-st/captcha.php';
    } else {

        if ($set['adm'] === $adm && password_verify($pass, $set['pass'])) {
            $_SESSION['admin'] = true;
            $_SESSION['admin_login'] = $set['adm'];
            $_SESSION['login_attempts'] = 0;
            
            header("Location: /admin/");
            exit();
        } else {
            $_SESSION['login_attempts']++;
            if ($_SESSION['login_attempts'] >= 3) {
                $_SESSION['block_time'] = time();
                echo '<div class="alert alert-danger">Неверный логин или пароль. Доступ заблокирован на 15 минут.</div>';
            } else {
                echo '<div class="alert alert-danger">Неверный логин или пароль. Осталось попыток: ' . (3 - $_SESSION['login_attempts']) . '</div>';
            }
        }
        include 'captcha/captcha-st/captcha.php';
    }
}

if (!isset($_SESSION['admin']) || !$_SESSION['admin']) {
    echo '
    <div class="bg-index"><br>
        <div class="title-page">
            <h2 style="color: #fff;">Вход в админ-панель</h2>
        </div>
        <div class="container">
            <center>
                <p class="text-light" style="position: relative;z-index: 99;">
                    Введите логин и пароль для доступа к админ-панели.
                </p>
            </center><br><br><br>
        </div>
    </div>
    
    <div class="container">
        <div class="row">
            <div class="col-lg-4 col-md-3"></div>
            <div class="col-lg-4 col-md-6">
                <div class="alert bg-light stat" style="margin-top: -55px;">
                    <h5>Форма авторизации</h5><hr>
                    <form action="" method="POST" autocomplete="off">
                        <div class="form-group login-form">
                            <input type="text" name="adm" placeholder="Логин" class="form-control" required>
                            <input type="password" name="pass" placeholder="Пароль" class="form-control mt-3" required>
                            <img src="/captcha/captcha-st/captcha.php" alt="Капча" style="margin-top: 5px;">
                            <input type="text" name="captcha" placeholder="Введите капчу" class="form-control mt-3" required>
                            <input type="submit" name="ok" value="Войти" class="btn btn-info btn-lg mt-3" style="width: 100%;">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>';
} else {

    echo '<div class="bg-index"><br/>
    <div class="title-page">
        <h2 style="color: #fff;">Админ панель</h2>
    </div>
    <div class="container">
        <center>
            <p class="text-light" style="position: relative;z-index: 99;font-size: 120%;">Добро пожаловать, ' . htmlspecialchars($_SESSION['admin_login']) . '</p>
        </center>
    </div><br/>
    </div><br/>';

    echo '<div class="container mt-4">
    <div class="row">
        <div class="col-md-3 mb-3">
            <a href="/admin/?case=viiew" class="text-decoration-none">
                <div class="card bg-primary text-white text-center p-3">
                    <h5>Площадки в iframe</h5>
                </div>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="/admin/filtr" class="text-decoration-none">
                <div class="card text-white text-center p-3" style="background-color: #ff7518;">
                    <h5>Фильтр URL</h5>
                </div>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="/admin/sett" class="text-decoration-none">
                <div class="card bg-info text-white text-center p-3">
                    <h5>Настройки сайта</h5>
                </div>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="/admin/history" class="text-decoration-none">
                <div class="card bg-warning text-dark text-center p-3">
                    <h5>История платежей</h5>
                </div>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="/admin/cod" class="text-decoration-none">
                <div class="card bg-danger text-white text-center p-3">
                    <h5>Редактор подвала</h5>
                </div>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="/admin/cod2" class="text-decoration-none">
                <div class="card bg-secondary text-white text-center p-3">
                    <h5>Редактор счётчиков</h5>
                </div>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="/admin/cod3" class="text-decoration-none">
                <div class="card bg-dark text-white text-center p-3">
                    <h5>Правила и контакты</h5>
                </div>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="/admin/news" class="text-decoration-none">
                <div class="card bg-success text-white text-center p-3">
                    <h5>Управление новостями</h5>
                </div>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="/admin/blog" class="text-decoration-none">
                <div class="card bg-purple text-white text-center p-3 shadow-sm" style="background-color: #6f42c1;">
                    <h5>Управление блогом</h5>
                </div>
            </a>
        </div>
    </div>
    </div>';

    $case = isset($_GET['case']) ? $_GET['case'] : '';
    switch ($case) {
        case 'viiew':
            echo '<div class="bg-index"><br/>
                <div class="title-page">
                    <h2 style="color: #fff;">Список площадок</h2>
                </div>
                <br/>
            </div><br/>
            <div class="container">
                <div class="row">';

            $query = "SELECT * FROM `iframe` WHERE `expire` > NOW() AND `status` = '1' ORDER BY `id` ASC";
            $result = $pdo->query($query)->fetchAll();

            if (!empty($result)) {
                foreach ($result as $link) {
                    echo '<div class="col-md-4 mb-4">
                        <div class="card shadow">
                            <div class="card-body">
                                <h5 class="card-title">
                                    <a ' . (($link['color'] || $link['bold'] || $link['italic']) ? 'style="' . ($link['bold'] ? 'font-weight:bold;' : '') . ($link['italic'] ? 'font-style:italic;' : '') . ($link['color'] ? 'color:' . $link['color'] : '') . '" ' : '') . 'href="' . $link['url'] . '" target="_blank">' . $link['url'] . '</a>
                                </h5>
                                <p class="card-text">Истекает: ' . $link['expire'] . '</br> Трафик: ' . $link['traffic'] . '</p>
                                <div class="btn-group">
                                    <a href="/admin/?case=edit_iframe&id=' . $link['id'] . '" class="btn btn-sm btn-outline-warning">
                                         Редактировать
                                    </a>
                                    <a href="/admin/?case=delete_iframe&id=' . $link['id'] . '" 
                                       class="btn btn-sm btn-outline-danger" 
                                       onclick="return confirm(\'Вы уверены, что хотите удалить эту площадку?\')">
                                         Удалить
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>';
                }
            } else {
                echo '<div class="col-12">
                    <div class="alert alert-warning text-center">
                        <b>ЗАКАЗОВ НЕТ!</b>
                    </div>
                  </div>';
            }

            echo '</div>
            </div>
            </div><br/>';
            echo '<div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-3"></div>
                    <div class="col-lg-4 col-md-6">
                        <div class="alert bg-light stat" style="margin-top: -55px;">
                            <center><a href="/admin/" class="btn btn-secondary">Админ панель</a></center>
                        </div>
                    </div>
                </div>
            </div>';
            break;

        case 'edit_iframe':
            if (isset($_GET['id'])) {
                $id = intval($_GET['id']);
                echo '<div class="container">
                    <div class="alert alert-info">
                        <h4>Редактирование площадки ID: ' . $id . '</h4>
                        <form method="post" action="/admin/?case=update_iframe">
                            <input type="hidden" name="id" value="' . $id . '">
                            <div class="form-group">
                                <label>URL:</label>
                                <input type="text" name="url" class="form-control" value="">
                            </div>
                            <div class="form-group">
                                <label>Дата окончания:</label>
                                <input type="datetime-local" name="expire" class="form-control">
                            </div>
                            <button type="submit" class="btn btn-primary">Сохранить</button>
                            <a href="/admin/?case=viiew" class="btn btn-secondary">Отмена</a>
                        </form>
                    </div>
                </div>';
            }
            break;

        case 'update_iframe':
            if (isset($_POST['id'])) {
                $id = intval($_POST['id']);
                $url = $_POST['url'];
                $expire = $_POST['expire'];
                
                $query = "UPDATE `iframe` SET `url` = ?, `expire` = ? WHERE `id` = ?";
                $stmt = $mysqli->prepare($query);
                $stmt->bind_param('ssi', $url, $expire, $id);
                if ($stmt->execute()) {
                    header("Location: /admin/?case=viiew");
                    exit();
                } else {
                    echo '<div class="alert alert-danger">Ошибка при обновлении площадки.</div>';
                }
            }
            break;

        case 'delete_iframe':
            if (isset($_GET['id'])) {
                $id = intval($_GET['id']);
                $query = "DELETE FROM `iframe` WHERE `id` = ?";
                $stmt = $mysqli->prepare($query);
                $stmt->bind_param('i', $id);
                if ($stmt->execute()) {
                    echo '<div class="alert alert-success">Площадка успешно удалена!</div>';
                    header("Location: /admin/?case=viiew");
                    exit();
                } else {
                    echo '<div class="alert alert-danger">Ошибка при удалении площадки.</div>';
                }
            } else {
                echo '<div class="alert alert-warning">Не указан ID площадки для удаления.</div>';
            }
            break;

        default:
        
            break;
    }
}

require_once '../sys/foot.php';
?>