<?php
declare(strict_types=1);

$title = 'Главная страница ' . ($_SERVER['HTTP_HOST'] ?? '') . ' - Биржа трафика, купить посетителей на сайт, купить трафик на сайт.';
error_reporting(E_ALL);
ini_set('display_errors', '1');
require_once 'sys/sys.php';
require_once 'sys/db.php';
require_once 'sys/head.php';

function pluralDays($n) {
    $n = abs($n) % 100;
    $n1 = $n % 10;
    if ($n > 10 && $n < 20) return 'дней';
    if ($n1 > 1 && $n1 < 5) return 'дня';
    if ($n1 == 1) return 'день';
    return 'дней';
}

$query = "SELECT * FROM `sett`";
$result = $mysqli->query($query);

if (!$result) {
    die('Ошибка запроса: ' . $mysqli->error);
}

$sett = $result->fetch_assoc();
$isd = $sett['cena'] ?? 0;
$iframeQuery = "SELECT COUNT(*) as total FROM `iframe` WHERE `status` = 1 AND `expire` >= NOW()";
$iframeResult = $mysqli->query($iframeQuery);

if (!$iframeResult) {
    die('Ошибка запроса: ' . $mysqli->error);
}

$iframeRow = $iframeResult->fetch_assoc();
$totalActiveIframes = $iframeRow['total'] ?? 0;
$reklamaQuery = "SELECT COUNT(*) as total FROM `reklama` WHERE `status` = 1 AND `expire` >= NOW()";
$reklamaResult = $mysqli->query($reklamaQuery);

if (!$reklamaResult) {
    die('Ошибка запроса: ' . $mysqli->error);
}

$reklamaRow = $reklamaResult->fetch_assoc();
$totalActiveReklama = $reklamaRow['total'] ?? 0;
$totalActiveRecordsQuery = "SELECT (SELECT COUNT(*) FROM `reklama` WHERE `status` = 1) + 
                                  (SELECT COUNT(*) FROM `iframe` WHERE `status` = 1) as total";
$totalActiveRecordsResult = $mysqli->query($totalActiveRecordsQuery);

if (!$totalActiveRecordsResult) {
    die('Ошибка запроса: ' . $mysqli->error);
}

$totalActiveRecordsRow = $totalActiveRecordsResult->fetch_assoc();
$totalActiveRecords = $totalActiveRecordsRow['total'] ?? 0;
$systemStartDate = strtotime('2025-03-08 06:29:00');
$currentDate = time();
$daysSinceStart = intval(($currentDate - $systemStartDate) / 86400);
$daysWord = pluralDays($daysSinceStart);

echo '<div class="jumbotron jumbotron-fluid text-light text-center bg-index" style="margin-bottom: 0;">
    <br/>
    <div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">
            <div class="carousel-item active"> 
                <center>
                    <img src="/css/images/index/payed.png" style="width: 128px;opacity: 0.9;" alt="Заработок на буксе"><br><br/>
                </center>
                <h1 class="wow bounceInLeft">Стабильный iFrame трафик</h1>
                <p class="wow bounceInRight">Качественный трафик для вас</p>
                <a href="/pay" class="btn btn-outline-primary wow shake">Разместить</a>
            </div>
            <div class="carousel-item">   
                <center>
                    <img src="/css/images/index/start.png" style="width: 128px;opacity: 0.9;" alt="Реклама во фрейме"><br><br/>
                </center>
                <h1 class="wow bounceInLeft">Эффективная реклама</h1>
                <p>Получай десятки посетителей на свой сайт</p>
                <a href="/pay" class="btn btn-outline-primary wow shake">Разместить</a>
            </div>
            <div class="carousel-item">   
                <center>
                    <img src="/css/images/index/users.png" style="width: 128px;opacity: 0.9;" alt="Станьте нашим партнёром"><br><br/>
                </center>
                <h1 class="wow bounceInLeft">Станьте нашим партнёром</h1>
                <p>Станьте частью нашего успеха</p>
                <a href="/pay/?type=adv" class="btn btn-outline-primary wow shake">Разместить</a>
            </div>
        </div>
        <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="sr-only">Previous</span>
        </a>
        <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="sr-only">Next</span>
        </a>
    </div>
    <br/><br/><br/>
</div>';

echo '<div class="container">
    <div class="row text-center">
        <div class="col-md-6">
            <div class="alert bg-light">
                <img src="/css/images/index/start.png" style="width: 128px;opacity: 0.9;" alt="Стать партнёром">
                <div class="title-page">
                    <h3>Партнёры</h3>
                </div>';
require_once 'file.php';
echo '            </div>
<p><a href="/pay/?type=adv" class="btn btn-outline-primary wow shake">Разместить</a></p>
        </div>
        <div class="col-md-6">
            <div class="alert bg-light">
                <img src="/css/images/index/payed.png" style="width: 128px;opacity: 0.9;" alt="Купить дешево iFrame">
                <div class="title-page">
                    <h3>iFrame дешево</h3>
                </div>
                <p><b>Раскрутить сайт всего за <b>' . htmlspecialchars($isd) . ' руб.</b></b></p>
                <p><a href="/pay" class="btn btn-outline-primary wow shake">Разместить</a></p>
            </div>
        </div>
    </div>
</div>

<div class="stat bg-light">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <div class="stat-block">
                    <img src="/css/images/index/2.png" style="width: 64px;opacity: 0.9;" alt="1"><br/>
                    <h4>' . $totalActiveIframes . '</h4>
                    <p>Активных площадок в iFrame</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-block">
                    <img src="/css/images/index/1.png" style="width: 64px;opacity: 0.9;" alt="1"><br/>
                    <h4>' . $totalActiveReklama . '</h4>
                    <p>Активных партнёров</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-block">
                    <img src="/css/images/index/3.png" style="width: 64px;opacity: 0.9;" alt="1"><br/>
                    <h4>' . $totalActiveRecords . '</h4>
                    <p>Количество размещений за ' . $daysSinceStart . ' ' . $daysWord . ' работы нашей системы</p>
                </div>
            </div>
        </div>
    </div>
</div>';

require_once 'sys/foot.php';
?>