<?php
$title = 'О нас';
require_once 'sys/sys.php';
require_once 'sys/db.php';

echo '<!DOCTYPE html>
<html lang="ru" itemscope itemtype="http://schema.org/WebPage">
<head>
    <meta charset="UTF-8">
    <meta name="description" content="AdRed iFrame-Трафик - невидимые посетители для вашего сайта. Увеличьте посещаемость от '.htmlspecialchars($isd, ENT_QUOTES, 'UTF-8').' рублей">
    <link rel="canonical" href="https://'.htmlspecialchars($_SERVER['HTTP_HOST'], ENT_QUOTES, 'UTF-8').'/about">
    <meta name="robots" content="index, follow">';

require_once 'sys/head.php';

$query = "SELECT * FROM `sett`";
$result = $mysqli->query($query);

if (!$result) {
    die('Ошибка запроса: ' . $mysqli->error);
}

$sett = $result->fetch_assoc();
$isd = $sett['cena'] ?? 0;
?>

<div class="bg-index"><br/>
    <div class="title-page">
        <h2 style="color: #fff;">О нас</h2>
    </div>
    <div class="container">
        <center>
            <p class="text-light" style="position: relative; z-index: 99; font-size: 120%;">AdRed iFrame-Трафик</p>
        </center>
    </div><br/>
</div><br/>

<div class="container" itemscope itemtype="https://schema.org/AboutPage">
    <center>
        <div class="row">
            <div class="col-md-12">
                <div class="card bg-light">
                    <div class="card-header" itemprop="headline">AdRed iFrame-Трафик — Невидимые Посетители для Вашего Сайта</div>
                    <div class="card-body" itemprop="description">
                        <div class="card-body">
                            <p itemprop="text">Хотите увеличить посещаемость вашего сайта и привлечь больше внимания к вашему проекту? С AdRed iFrame-трафиком это стало проще, чем когда-либо!</p>
                            
                            <p><b itemprop="featureList">Наш уникальный инструмент позволяет:</b></p>
                            <ul style="list-style-type: none;" itemscope itemtype="https://schema.org/ItemList">
                                <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                                    <meta itemprop="position" content="1" />
                                    <span itemprop="item">• Увеличить количество кликов по вашей рекламе</span>
                                </li>
                                <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                                    <meta itemprop="position" content="2" />
                                    <span itemprop="item">• Повысить показы в баннерных сетях</span>
                                </li>
                                <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                                    <meta itemprop="position" content="3" />
                                    <span itemprop="item">• Улучшить позиции в рейтингах и статистике</span>
                                </li>
                                <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                                    <meta itemprop="position" content="4" />
                                    <span itemprop="item">• Создать видимость активной аудитории на вашем сайте</span>
                                </li>
                                <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                                    <meta itemprop="position" content="5" />
                                    <span itemprop="item">• Привлечь внимание рекламодателей и партнеров</span>
                                </li>
                            </ul>
                            
                            <p itemprop="offers" itemscope itemtype="https://schema.org/Offer">Мы предлагаем выгодные условия для покупки iFrame-трафика. Закажите продвижение вашего сайта всего за <span itemprop="price"><?php echo htmlspecialchars($isd); ?></span> <span itemprop="priceCurrency">рублей</span> и получите мгновенный результат!</p>
                            
                            <p itemprop="text">Не упустите шанс выделиться среди конкурентов и сделать ваш сайт более популярным. Попробуйте AdRed iFrame-трафик уже сегодня!</p>
                            <p><a href="/pay" class="btn btn-outline-primary wow shake" rel="nofollow">Разместить?</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </center>
</div>

<?php
require_once 'sys/foot.php';
?>