<?php
$title = 'Правила';
require_once 'sys/sys.php';
require_once 'sys/db.php';

echo '<!DOCTYPE html>
<html lang="ru" itemscope itemtype="http://schema.org/WebPage">
<head>
    <meta charset="UTF-8">
    <meta name="description" content="Правила использования сервиса ' . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_QUOTES, 'UTF-8') . '">
    <link rel="canonical" href="https://' . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_QUOTES, 'UTF-8') . '/rules">
    <meta name="robots" content="index, follow">';

require_once 'sys/head.php';
?>

<div class="bg-index"><br/>
    <div class="title-page">
        <h2 style="color: #fff;">Правила</h2>
    </div>
    <div class="container">
        <center>
            <p class="text-light" style="position: relative; z-index: 99; font-size: 120%;">
                Правила системы <b><?php echo htmlspecialchars($_SERVER['HTTP_HOST']); ?></b>
            </p>
        </center>
    </div><br/>
</div><br/>

<div class="container" itemscope itemtype="https://schema.org/ItemList">
    <center>
        <div class="row">
            <div class="col-md-12">
                <div class="card bg-light">
                    <div class="card-header" itemprop="name">Используя услуги <font color="blue"><?php echo htmlspecialchars($_SERVER['HTTP_HOST']); ?></font>, вы автоматически соглашаетесь с нижеследующими правилами. Администрация оставляет за собой право вносить дополнения и изменения в правила без предварительного предупреждения.</div>
                    <div class="card-body" itemprop="description">
                        <div itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <meta itemprop="position" content="1" />
                            <div itemscope itemtype="https://schema.org/WebContent">
                                1. Запрещено ставить сайты на фрейм с кодами слива трафика на партнерские и баннерные сети, принимающие показы (фрейм). При обнаружении сайт удаляется, деньги не возвращаются!
                            </div>
                        </div>
                        <br>
                        <div itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <meta itemprop="position" content="2" />
                            <div itemscope itemtype="https://schema.org/WebContent">
                                2. Запрещено ставить сайты на фрейм с кодами переадресации на мобильные смс подписки. При обнаружении сайт удаляется, деньги не возвращаются!
                            </div>
                        </div>
                        <br>
                        <div itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <meta itemprop="position" content="3" />
                            <div itemscope itemtype="https://schema.org/WebContent">
                                3. Запрещено ставить сайты на фрейм со счетчиками содержащими JavaScript код переадресации трафика. При обнаружении сайт удаляется, деньги не возвращаются!
                            </div>
                        </div>
                        <br>
                        <div itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <meta itemprop="position" content="4" />
                            <div itemscope itemtype="https://schema.org/WebContent">
                                4. Запрещено ставить на сайт iframe код переадресации трафика на другой сайт. При обнаружении сайт удаляется, деньги не возвращаются!
                            </div>
                        </div>
                        <br>
                        <div itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <meta itemprop="position" content="5" />
                            <div itemscope itemtype="https://schema.org/WebContent">
                                5. Запрещено ставить на сайт для перепродажи трафика либо на сильно загруженные страницы. При обнаружении сайт удаляется, деньги не возвращаются!
                            </div>
                        </div>
                        <br>
                        <div itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <meta itemprop="position" content="6" />
                            <div itemscope itemtype="https://schema.org/WebContent">
                                6. Запрещено покупать фрейм на страницу, на которую уже куплен ранее трафик на любом другом подобном сайте!
                            </div>
                        </div>
                        <br><br>
                        <div itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <meta itemprop="position" content="7" />
                            <div itemscope itemtype="https://schema.org/WebContent">
                                <font color="red">* Любое нарушение выше перечисленных правил приведет к некачественному трафику, к минимальным просмотрам либо удалению площадки без возвращения средств!</font>
                            </div>
                        </div>
                        <br>
                        <div itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <meta itemprop="position" content="8" />
                            <div itemscope itemtype="https://schema.org/WebContent">
                                <font color="red">* Качество трафика может меняться в зависимости от количества заказов или от качества закупленного трафика. Также при такой раскрутке сайта ваш сайт может попасть в блок от топ рейтингов. Покупая трафик, администрация сайта <font color="blue"><?php echo htmlspecialchars($_SERVER['HTTP_HOST']); ?></font> не несет ответственности и не возвращает денежные средства!</font>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </center>
</div>

<?php
require_once 'sys/foot.php';
?>