<?php
/**
* Online users counter - This will count the number of users online by their ip
* author: ionutvmi@gmail.com
* 23-sep-2012
*/

$plugins->add_hook("footer","online_show");
$plugins->add_hook("header_end","online_count");


function online_info(){
	return	array(	
		"name" => "Online Counter",
		"author" => "ionutvmi",
		"author_site" => "http://master-land.net",
		"description" => "This will count the number of users online by their ip",
		);
}


function online_install(){
	global $db;
	$settings_data = array(
	"name" => "online_time", 
	"value" => "300", 
	"title" => "Time", 
	"description" => "how long will a user be countent as online(seconds)", 
	"type" => "text",
	"plugin" => "online", 
	);
	$settings_data2 = array(
	"name" => "online_show_users", 
	"value" => "1", 
	"title" => "Show user data ?", 
	"description" => "if yes it will show user data(ip,browser,page) in a page", 
	"type" => "yesno",
	"plugin" => "online", 
	);
	$db->insert_array(MAI_PREFIX."plugins_settings",$settings_data);
	$db->insert_array(MAI_PREFIX."plugins_settings",$settings_data2);

}


function online_is_installed(){
	global $db;
	if($db->count("SELECT `name` FROM `".MAI_PREFIX."plugins_settings` WHERE `plugin`='online'") > 0)
		return true;
	
	return false;
}

function online_uninstall(){
	global $db;
	$db->query("DELETE FROM `".MAI_PREFIX."plugins_settings` WHERE `plugin`='online'");
	@unlink(MAI_ROOT."plugins/tmp/online_dat.txt");
}


function online_show($value){
	global $set,$_online_count;
	
	$how_many = $_online_count;


	$value = str_replace("<!--footer start-->","<!--footer start--> <div><div class='menuhead'><center>Online ".($set->plugins["online_show_users"] == 1 ? "<a href='$set->url/who.php'> $how_many </a>" : $how_many)."<center></div></div>",$value);
	
	return $value;
}




function online_count(){
	global $set, $_online_count;
	
	
	$expire = $set->plugins["online_time"];
	
	$dbfile = MAI_ROOT."plugins/tmp/online_dat.txt";
	@chmod($dbfile,0666);
	if(!empty($_SERVER["HTTP_CLIENT_IP"])){
		$ip = $_SERVER["HTTP_CLIENT_IP"];
	}else if(!empty($_SERVER["HTTP_X_FORWARDED_FOR"])){
		$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
	}else{
		$ip = $_SERVER["REMOTE_ADDR"];
	}
	$cur_ip = $ip;
	$cur_time = time();
	$dbary_new = array();
	
	// get the data from the file
	$dbary = unserialize(@file_get_contents($dbfile));
	if(is_array($dbary)){
		// we remove the current ip and expiered ones
		while(list($user_ip, $user_data) = each($dbary)){
			if(($user_ip != $cur_ip) && (($user_data['time'] + $expire) > $cur_time)){
				$dbary_new["$user_ip"] = $user_data;
			}
		}
	}
	// grab the data for the current ip
	$cur_data['time'] = $cur_time;
	$cur_data['browser'] = $_SERVER['HTTP_USER_AGENT'];
	$cur_data['page'] = $_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'];
	$dbary_new["$cur_ip"] = $cur_data;
	// enter the data back to the file
	$fp = fopen($dbfile, "w");
	fputs($fp, serialize($dbary_new));
	fclose($fp);
	
	
	$_online_count = sprintf("%02d", count($dbary_new));
	
	return true;
	
}