<!DOCTYPE html>
<html lang="ru">
<head>
	{headers}
	 <meta name="viewport" content="width=device-width, initial-scale=1.0" />
	  <link rel="shortcut icon" href="{THEME}/images/favicon.png" />
	  <link href="{THEME}/style/styles.css" type="text/css" rel="stylesheet" />
	  <link href="{THEME}/style/engine.css" type="text/css" rel="stylesheet" />
	  <link href="{THEME}/style/filter-xf.css" type="text/css" rel="stylesheet" />
	  <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,600|Oswald:700&amp;subset=cyrillic" rel="stylesheet"> 	  
	  <meta name="theme-color" content="#111">
</head>

<body>

<div class="wrap">

	<div class="wrap-center wrap-main">
	
		<header class="header" id="header">
			<div class="header-in wrap-center fx-row fx-middle">
				<a href="/" class="logo"><img src="{theme}/images/logo.png" alt="" /></a>
				<div class="btn-menu"><span class="fa fa-bars"></span></div>
				{include file="main-menu.tpl"}
				<div class="search-wrap fx-1 to-mob">
					<form id="quicksearch" method="post">
						<input type="hidden" name="do" value="search" />
						<input type="hidden" name="subaction" value="search" />
						<div class="search-box">
							<input id="story" name="story" placeholder="Введите название" type="text" />
							<button type="submit"><span class="fa fa-search"></span></button>
						</div>
					</form>
				</div>
				[group=5]<div class="btn-login btn js-login to-mob">Войти</div>[/group]
				[not-group=5]<div class="btn-login btn js-login to-mob">Кабинет</div>[/not-group]
			</div>
		</header>
		
		<!-- END HEADER -->
		
		<div class="content">
			{info}
		
			<main class="main">
				[available=main]{include file="main-page.tpl"}[/available]
				[available=cat]
				<div class="sect">
					<div class="sect-header fx-row fx-middle">
						<div class="sect-title">{category-title}<span class="fa fa-chevron-down"></span></div>
						<div class="filter-btn icon-left btn"><span class="fa fa-sliders"></span>Фильтр</div>
					</div>
					<div class="sect">{include file="main-filter.tpl"}</div>
					<div class="sect-cont sect-items clearfix">
						{content}
					</div>
				</div>
				[/available]
				[not-available=main|cat]
				<div class="speedbar nowrap">{speedbar}</div>
				<div class="clearfix" id="in-full">{content}</div>
				[/not-available]
				{include file="main-seo.tpl"}
			</main>
		
		</div>
		
		<!-- END CONTENT -->
		
		<footer class="footer fx-row">
			<div class="ft-col ft-desc">
				(C) Copyright "LordFilm" - на сайте 32.564 картины с хорошим HD качеством.
				<div class="ft-counter"><img src="{theme}/images/count.png" alt=""></div>
			</div>
			<div class="ft-col ft-menu">
				<p>2019</p>
				<ul>
				<li><a href="/filmy-2019/">Фильмы 2019</a></li>
				<li><a href="/serialy-2019/">Сериалы 2019</a></li>
				<li><a href="/multfilmy-2019/">Мультики 2019</a></li>
				<li><a href="/anime-2019/">Аниме 2019</a></li>
				</ul>
			</div>
			<div class="ft-col ft-menu">
				<p>2019</p>
				<ul>
				<li><a href="/filmy-2019/">Фильмы 2019</a></li>
				<li><a href="/serialy-2019/">Сериалы 2019</a></li>
				<li><a href="/multfilmy-2019/">Мультики 2019</a></li>
				<li><a href="/anime-2019/">Аниме 2019</a></li>
				</ul>
			</div>
		</footer>
		
		<!-- END FOOTER -->
	
	</div>
	
	<!-- END WRAP-MAIN -->

</div>

<!-- END WRAP -->

{login}

{jsfiles}
<script src="{THEME}/js/libs.js"></script>
{AJAX}
<script src="{THEME}/js/filter-xf.js"></script>

</body>
</html>
