<?php

include_once '../sys/inc/start.php';
$doc = new document();
$doc->title = __('Новый раздел');

if (!isset($_GET['id_category']) || !is_numeric($_GET['id_category'])) {
    if (isset($_GET['return']))
        header('Refresh: 1; url=' . $_GET['return']);
    else
        header('Refresh: 1; url=./?' . SID);
    $doc->err(__('Ошибка выбора категории'));
    exit;
}
$id_category = (int) $_GET['id_category'];

$q = $db->prepare("SELECT * FROM `forum_categories` WHERE `id` = ? AND `group_write` <= ?");
$q->execute(Array($id_category, $user->group));
if (!$category = $q->fetch()) {
    if (isset($_GET['return']))
        header('Refresh: 1; url=' . $_GET['return']);
    else
        header('Refresh: 1; url=./?' . SID);
    $doc->err(__('В выбранной категории запрещено создавать разделы'));
    exit;
}


if (isset($_POST['name'])) {
    $name = text::for_name($_POST['name']);
    $description = text::input_text($_POST['description']);
    if (!$name) {
        $doc->err(__('Введите название раздела'));
    } else {
        $res = $db->prepare("INSERT INTO `forum_topics` (`id_category`, `time_create`,`time_last`, `name`, `description`, `group_show`, `group_write`, `group_edit`) VALUES (?,?,?,?,?,?,?,?)");
        $res->execute(Array($category['id'], TIME, TIME, $name, $description, $category['group_show'], max($category['group_show'], 1), max($user->group, 4)));
        $id_topic = $db->lastInsertId();
        $doc->msg(__('Раздел успешно создан'));

        $dcms->log('Форум', 'Создание раздела [url=/forum/topic.php?id=' . $id_topic . ']' . $name . '[/url] в категории [url=/forum/category.php?id=' . $category['id'] . ']' . $category['name'] . '[/url]');

        if (isset($_GET['return'])) {
            header('Refresh: 1; url=' . $_GET['return']);
            $doc->ret(__('Вернуться'), text::toValue($_GET['return']));
        } else {
            header('Refresh: 1; url=topic.php?id=' . $id_topic . '&' . SID);
            $doc->ret(__('В раздел'), 'topic.php?id=' . $id_topic);
        }

        exit;
    }
}

$doc->title = $category['name'] . ' - ' . __('Новый раздел');

$form = new form("?id_category=$category[id]&amp;" . passgen() . (isset($_GET['return']) ? '&amp;return=' . urlencode($_GET['return']) : null));
$form->text('name', __('Название раздела'));
$form->textarea('description', __('Описание'));
$form->button(__('Создать раздел'));
$form->display();

if (isset($_GET['return']))
    $doc->ret(__('В категорию'), text::toValue($_GET['return']));
else
    $doc->ret(__('В категорию'), 'category.php?id=' . $category['id']);
