<?php

$subdomain_theme_redirect_disable = true; // принудительное отключение редиректа на поддомены, соответствующие типу браузера
include_once '../sys/inc/start.php';
$doc = new document();
$doc->title = __('Регистрация');

if ($user->group) {
    $doc->access_denied(__('Вы уже зарегистрированы'));
}

if (!$dcms->reg_open) {
    $doc->access_denied(__('Регистрация временно закрыта'));
}

$error = false;
// пригласительный
$inv = &$_SESSION['reg']['invite'];
if (!$inv && isset($_GET['invite']) && $_GET['invite']) {
    $q = $db->prepare("SELECT * FROM `invations` WHERE `code` = ? AND `id_invite` IS NULL AND `email` IS NOT NULL LIMIT 1");
    $q->execute(Array($_GET['invite']));
    if ($inv = $q->fetch()) {


        // $doc->msg('Пригласительный учтен');

        $res = $db->prepare("UPDATE `invations` SET `code` = null WHERE `id` = ? LIMIT 1");
        $res->execute(Array($inv['id']));
    } else {
        $doc->err(__('Пригласительный недействителен'));
    }
}

if (!isset($inv))
    $inv = false;

if (!$inv && $dcms->reg_with_invite) {
    $doc->access_denied(__('Регистрация возможна только по приглашению'));
}

$step = &$_SESSION['reg']['step'];
if (!isset($step)) {
    $step = $dcms->reg_with_rules ? 0 : 1;
}
$login = &$_SESSION['reg']['login'];
// принимаем правила
if ($step == 0 && isset($_GET['rules'])) {
    if ($_POST['ok']) {
        $step = 1;
        $doc->msg(__('Очень хорошо, надеемся на их соблюдение'));
    } elseif ($_POST['no']) {
        $doc->err(__('Для продолжения регистрации необходимо принять правила сайта'));
    }
}
// выбираем ник
if ($step == 1 && isset($_GET['nick']) && isset($_POST['login'])) {
    if (is_valid::nick($_POST['login'])) {
        $login = $_POST['login'];
        $res = $db->prepare("SELECT * FROM `users` WHERE login =?;");
        $res->execute(Array($login));
        if (!$res->fetch()) {
            if ($_POST['login'] != htmlspecialchars($_POST['login'])) {
                $doc->err(__('В нике содержатся запрещенные символы'));
            } else {

                $step = 2;
                $_SESSION['reg']['login'] = $_POST['login'];
                $doc->msg(__('Ник может быть успешно зарегистрирован'));
            }
        } else {
            $doc->err(__('Ник занят другим пользователем'));
        }
    } else {
        $doc->err(__('Недопустимый ник'));
    }
}
// выбираем ник
if ($step == 2 && isset($_GET['final']) && isset($_POST['sex'])) {
    $sex = $_POST['sex'] ? 1 : 0;

    if (empty($_POST['captcha']) || empty($_POST['captcha_session']) || !captcha::check($_POST['captcha'], $_POST['captcha_session'])) {
        $doc->err(__('Проверочное число введено неверно'));
        $error = true;
    }

    if ($dcms->reg_with_mail && !$inv) {
        if (empty($_POST['mail'])) {
            $doc->err(__('Необходимо указать E-mail'));
            $error = true;
        }
        if (!is_valid::mail($_POST['mail'])) {
            $doc->err(__('Указан не корректный E-mail'));
            $error = true;
        }

        $res = $db->prepare("SELECT * FROM users WHERE `reg_mail`=?");
        $res->execute(Array($_POST['mail']));
        if ($res->fetch()) {
            $doc->err(__('Пользователь с таким e-mail уже зарегистрирован'));
            $error = true;
        }
        if (empty($_POST['password'])) {
            $doc->err(__('Необходимо указать пароль'));
            $error = true;
        }
        if (empty($_POST['password_retry'])) {
            $doc->err(__('Необходимо подтвердить пароль'));
            $error = true;
        }
        if ($_POST['password_retry'] != $_POST['password']) {
            $doc->err(__('Введенные пароли не совпадают'));
            $error = true;
        }
        if (!is_valid::password($_POST['password'])) {
            $doc->err(__('Не корректный пароль'));
            $error = true;
        }

        //Если нет ошибок
        if (!$error) {

            $a_code = md5(passgen());

            $res = $db->prepare("INSERT INTO `users` (`reg_date`, `login`, `password`, `sex`, `a_code`, `reg_mail`) VALUES (?, ?, ?, ?, ?, ?)");
            $res->execute(Array(TIME, $_SESSION['reg']['login'], crypt::hash($_POST['password'], $dcms->salt), $sex, $a_code, $_POST['mail']));
            $id_user = $db->lastInsertId();

            if ($id_user && is_numeric($id_user)) {


                if ($susp = is_valid::suspicion($inv['email'] . ' ' . $_SESSION['reg']['login'])) {
                    // подозрительный e-mail или логин
                    $res = $db->prepare("INSERT INTO `users_suspicion` (`id_user`, `text`) VALUES (?, ?)");
                    $res->execute(Array($id_user, $susp));
                    $dcms->distribution("Пользователь [user]{$id_user}[/user] сочтен подозрительным, так как в нике или адресе email была обнаружена несвязная комбинация символов: {$susp}\n[url=/dpanel/users.suspicious.php]Список подозрительных пользователей[/url]", 4);
                }


                $t = new design();
                $t->assign('title', __('Успешная регистрация'));
                $t->assign('login', $_SESSION['reg']['login']);
                $t->assign('password', $_POST['password']);
                $t->assign('site', $dcms->sitename);
                $t->assign('url', 'http://' . $_SERVER['HTTP_HOST'] . '/activation.php?id=' . $id_user . '&amp;code=' . $a_code . (isset($_GET['return']) ? '&amp;return=' . urlencode($_GET['return']) : null));
                if (mail::send($_POST['mail'], 'Регистрация', $t->fetch('file:' . H . '/sys/templates/mail.activation.tpl'))) {
                    $step = 3;
                    //$doc->msg(__('На Ваш E-mail отправлено письмо с ссылкой для активации аккаунта'));
                } else
                    $doc->err(__('Ошибка при отправке email, попробуйте позже'));
            } else {
                $doc->err(__('Ошибка при регистрации. Попробуйте позже'));
                $step = 1;
            }
        }
    } elseif ($inv) {
        if (empty($_POST['password'])) {
            $doc->err(__('Необходимо указать пароль'));
            $error = true;
        }

        if (!isset($_POST['password_retry'])) {
            $doc->err(__('Необходимо подтвердить пароль'));
            $error = true;
        }

        if ($_POST['password_retry'] != $_POST['password']) {
            $doc->err(__('Введенные пароли не совпадают'));
            $error = true;
        }
        if (!is_valid::password($_POST['password'])) {
            $doc->err(__('Не корректный пароль'));
            $error = true;
        }

        $res = $db->prepare("SELECT * FROM `users` WHERE `reg_mail` = ?");
        $res->execute(Array($inv['email']));
        if ($res->fetch()) {
            $doc->err(__('Пользователь с таким e-mail уже зарегистрирован'));
            $error = true;
        }

        //Если нет ошибок
        if (!$error) {





            $res = $db->prepare("INSERT INTO `users` (`reg_date`, `login`, `password`, `sex`, `reg_mail`) VALUES(?, ?, ?, ?, ?)");
            $res->execute(Array(TIME, $_SESSION['reg']['login'], crypt::hash($_POST['password'], $dcms->salt), $sex, $inv['email']));
            $id_user = $db->lastInsertId();

            if ($id_user && is_numeric($id_user)) {

                if ($susp = is_valid::suspicion($inv['email'] . ' ' . $_SESSION['reg']['login'])) {
                    // подозрительный e-mail или логин
                    $res = $db->prepare("INSERT INTO `users_suspicion` (`id_user`, `text`) VALUES (?, ?)");
                    $res->execute(Array($id_user, $susp));
                    $dcms->distribution("Пользователь [user]{$id_user}[/user] сочтен подозрительным, так как в нике или адресе email была обнаружена несвязная комбинация символов: {$susp}\n[url=/dpanel/users.suspicious.php]Список подозрительных пользователей[/url]", 4);
                }



                $res = $db->prepare("UPDATE `invations` SET `id_invite` = ?, `time_reg` = ? WHERE `id` = ? LIMIT 1");
                $res->execute(Array($id_user, TIME, $inv['id']));
                $res = $db->prepare("UPDATE `users` SET `balls` = `balls` * '1.1' WHERE `id` = ? LIMIT 1");
                $res->execute(Array($inv['id_user']));
                $step = 3;
            }
        }
    } else {
        $res = $db->prepare("INSERT INTO `users` (`reg_date`, `login`, `password`, `sex`) VALUES (?, ?, ?, ?)");
        $res->execute(Array(TIME, $_SESSION['reg']['login'], crypt::hash($_POST['password'], $dcms->salt), $sex));
        $id_user = $db->lastInsertId();


        if ($id_user && is_numeric($id_user)) {

            if ($susp = is_valid::suspicion($_SESSION['reg']['login'])) {
                // подозрительный логин
                $res = $db->prepare("INSERT INTO `users_suspicion` (`id_user`, `text`) VALUES (?, ?)");
                $res->execute(Array($id_user, $susp));
                $dcms->distribution("Пользователь [user]{$id_user}[/user] сочтен подозрительным, так как в нике была обнаружена несвязная комбинация символов: {$susp}\n[url=/dpanel/users.suspicious.php]Список подозрительных пользователей[/url]", 4);
            }


            $step = 3;
        } else {
            $doc->err(__('Ошибка при регистрации. Попробуйте позже'));
            $step = 1;
        }
    }
}

if ($step == 3) {
    $doc->msg(__('Вы успешно зарегистрированы'));

    if ($dcms->reg_with_mail && !$inv) {
        echo __("На ваш E-mail отправлено письмо с ссылкой для активации аккаунта");
    } else {
        echo __("Теперь Вы можете <a href='%s'>Авторизоваться</a>", '/login.php' . (isset($_GET['return']) ? '?return=' . urlencode($_GET['return']) : null));
    }

    unset($_SESSION['reg']);
    exit;
}

if ($step == 2) {
    $doc->title = __('Завершение регистрации'); // заголовок страницы


    $form = new form('/reg.php?final&amp;' . passgen() . (isset($_GET['return']) ? '&amp;return=' . urlencode($_GET['return']) : null));
    $form->bbcode(__('Ваш ник: %s', '[b]' . $login . '[/b]'));
    $form->password('password', __('Пароль') . ' [6-32]');
    $form->password('password_retry', __('Повторите пароль'));
    $form->select('sex', __('Ваш пол'), array(array(1, __('Мужской')), array(0, __('Женский'))));
    if ($dcms->reg_with_mail && !$inv) {
        $form->text('mail', __('Ваш E-mail') . '*');
        $form->bbcode('* ' . __('На Ваш E-mail придет письмо с ссылкой для активации аккаунта'));
    }
    $form->captcha();
    $form->button(__('Зарегистрироваться'), 'post');
    $form->display();
    exit;
}

if ($step == 1) {
    $doc->title = __('Подбор ника'); // заголовок страницы

    $form = new form('/reg.php?nick&amp;' . passgen() . (isset($_GET['return']) ? '&amp;return=' . urlencode($_GET['return']) : null));
    $form->text('login', __('Выберите ник') . ' [A-zА-я0-9 -_]');
    $form->bbcode('- ' . __('Сочетание русского и английского алфавитов запрещено'));
    $form->bbcode('- ' . __('Использование пробелов вначале и конце строк запрещено'));
    $form->bbcode('- ' . __('Ник не должен начинаться с цифр'));
    $form->button(__('Продолжить'), 'post');
    $form->display();
    exit;
}

if ($step == 0) {
    $doc->title = __('Соглашение'); // заголовок страницы

    $form = new form('/reg.php?rules&amp;' . passgen() . (isset($_GET['return']) ? '&amp;return=' . urlencode($_GET['return']) : null));
    $form->bbcode(@file_get_contents(H . '/sys/docs/rules.txt'));
    $form->button(__('Принимаю'), 'ok', false);
    $form->button(__('Не принимаю'), 'no');
    $form->display();
    exit;
}
?>