CREATE TABLE IF NOT EXISTS `forum` (
  `id` int(11) not null auto_increment,
  `name` varchar(40) not null,
  `description` varchar(100) default null,
  `access` int(1) not null default '0',
  `output` int(1) not null default '0',
  `number` int(11) not null,
  `icon` varchar(32) DEFAULT 'folder',
  KEY `number` (`number`),
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Форум';

CREATE TABLE IF NOT EXISTS `forum_razdels` (
  `id` int(11) not null auto_increment,
  `id_forum` int(11) not null,
  `name` varchar(40) not null,
  `description` varchar(100) default null,
  `type` int(1) default '0' not null,
  `output` int(1) not null default '0',
  `number` int(11) not null,
  `icon` varchar(32) DEFAULT 'folder',
  KEY `number` (`number`),
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Разделы форума';

CREATE TABLE IF NOT EXISTS `forum_themes` (
  `id` int(11) not null auto_increment,
  `id_forum` int(11) not null,
  `id_razdel` int(11) not null,
  `id_user` int(11) not null,
  `id_admin` int(11) not null default '0',
  `name` varchar(100) not null,
  `description` text not null,
  `time` int(11) not null,
  `time_edit` int(11) not null,
  `time_post` int(11) not null,
  `reason_close` varchar(100) default null,
  `type` int(1) not null default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Темы форума';

CREATE TABLE IF NOT EXISTS `forum_posts` (
  `id` int(11) not null auto_increment,
  `id_theme` int(11) not null,
  `id_user` int(11) not null,
  `id_admin` int(11) not null,
  `text` text not null,
  `time` int(11) not null,
  `last_edit` int(11) not null default '0',
  `who_edit` varchar(50) default NULL,
  `count_edit` int(11) not null default '0',
  `cit` int(11) not null,
  `hide` int(1) not null default '0',
  `privat` int(1) not null default '0',
  `rating` int(11) not null,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Сообщения в темах форума';

CREATE TABLE IF NOT EXISTS `forum_post_rating` (
  `id` int(11) not null auto_increment,
  `id_theme` int(11) not null,
  `id_post` int(11) not null,
  `id_user` int(11) not null,
  `type` int(1) not null default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Рейтинг постов в темах';

CREATE TABLE IF NOT EXISTS `forum_post_files` (
  `id` int(11) not null auto_increment,
  `id_theme` int(11) not null,
  `id_post` int(11) not null,
  `id_user` int(11) not null,
  `name` varchar(64) not null,
  `real_name` varchar(100) not null,
  `size` int(20) not null,
  `count_downloads` int(11) not null default '0',
  PRIMARY KEY (`id`),
  KEY `id_post` (`id_post`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Файлы тем форума';

CREATE TABLE IF NOT EXISTS `forum_journal` (
  `id` int(11) not null auto_increment,
  `id_theme` int(11) not null,
  `id_user` int(11) not null,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Следить за темой форума';

CREATE TABLE IF NOT EXISTS `f_journal` (
  `id` int(11) not null auto_increment,
  `id_user` int(11) not null,
  `text` text not null,
  `type` varchar(10) not null,
  `time` int(11) not null,
  `read` int(1) not null default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Журнал форума';

CREATE TABLE IF NOT EXISTS `forum_votes` (
  `id` int(11) not null auto_increment,
  `id_theme` int(11) not null,
  `id_user` int(11) not null,
  `time` int(11) not null,
  `time_end` int(11) not null,
  `name` varchar(500) not null,
  PRIMARY KEY (`id`),
  KEY `id_theme` (`id_theme`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Опросы тем форума';

CREATE TABLE IF NOT EXISTS `forum_votes_var` (
  `id` int(11) not null auto_increment,
  `id_theme` int(11) not null,
  `id_vote` int(11) not null,
  `variant` varchar(100) default null,
  PRIMARY KEY (`id`),
  KEY `id_vote` (`id_vote`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Варианты ответов в опросах';

CREATE TABLE IF NOT EXISTS `forum_vote_voices` (
  `id` int(11) not null auto_increment,
  `id_vote` int(11) not null,
  `id_variant` int(11) not null,
  `id_user` int(11) not null,
  PRIMARY KEY (`id`),
  KEY `id_vote` (`id_vote`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Голоса в опросах';

CREATE TABLE IF NOT EXISTS `forum_reports` (
  `id` int(11) not null auto_increment,
  `id_theme` int(11) not null,
  `id_user` int(11) not null,
  `text` text not null,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'Жалобы к темам';

