<?php

class EmailUser {

    protected $address;

    public function __construct($to = null) {
        $this->address = $to;
    }

    public function getUser() {
        $callback = $this->getAddres();

        return call_user_func(array($this, $callback['method']));
    }

    protected function getAddres() {
        if (preg_match("#^[A-z0-9-\._-]+@[A-z0-9\._-]{2,}\.[A-z]{2,8}$#ui", $this->address)) {
            $data = array('method' => 'getUserEmail');
        } elseif ($this->address === '0') {
            $data = array('method' => 'getUserSystem');
        } elseif (is_numeric($this->address) || preg_match('/^([A-z0-9-\.-_]+)$/ui', $this->address, $matches)) {
            $data = array('method' => 'getUserSite');
        } else {
            $data = array('method' => 'getUserNew');
        }

        return $data;
    }

    protected function getUserEmail() {
        global $config;

        if (preg_match("#^[A-z0-9-\._-]+@[A-z0-9\._-]{2,}\.[A-z]{2,4}$#ui", $this->address)) {
            if (in_array(strtolower(preg_replace("/.*?@/", '', $this->address)), $config['aliase'])) {
                $user = mysql_fetch_assoc(mysql_query("SELECT * FROM `user` AS u WHERE `nick` = '" . mysql_real_escape_string(preg_replace("/@.*/", '', $this->address)) . "' LIMIT 1"));
                return $this->getUserSite($user);
            }
        }

        return array(
            'avatar' => '<img src="style/icons/email.jpg" />',
            'icon' => '<img src="style/icons/e.gif" />',
            'nick' => stripcslashes(htmlspecialchars($this->address)),
            'link' => stripcslashes(htmlspecialchars($this->address)),
            'id' => $this->address,
            'ban' => false,
        );
    }

    protected function getUserSite($user = null) {
        if ($user == null) {
            $user = mysql_fetch_assoc(mysql_query("SELECT * FROM `user` AS u WHERE `id` = '" . (int) $this->address . "' OR `nick` = '" . mysql_real_escape_string($this->address) . "' LIMIT 1"));
        }

        if (empty($user)) {
            return $this->getUserNew();
        }

        $user['avatar'] = $this->getAvatar($user['id'], '40');
        $user['icon'] = "<span class='fa fa-user fa-fw'></span>";
        $user['link'] = $user['icon'] . ' <a class="' . ($user['ban'] == true ? 'user-ban' : '') . '" href="/info.php?id=' . $user['id'] . '">' . $user['nick'] . '</a> ' . ($user['date_last'] > time() - 600 ? '<img src="style/icons/online.png" />' : '');
        return $user;
    }

    #Система сайта

    protected function getUserSystem() {
        return array(
            'avatar' => '',
            'icon' => "<span class='fa fa-life-ring'>",
            'id' => 0,
            'nick' => 'Система',
            'ncolor' => '000',
            'ncolor2' => '000',
            'ban' => false,
        );
    }

    /**
     * Если новое сообщение
     * @return Array()
     */
    protected function getUserNew() {
        return array(
            'avatar' => '',
            'icon' => '',
            'id' => '',
            'ban' => false,
            'nick' => 'Новое сообщение'
        );
    }

    #Определение аватара

    protected function getAvatar($id, $px = '40') {

        $ank = get_user($id);

        if ($ank['sex'] == 0) {
            $sex = 'zh.jpg';
        } else {
            $sex = 'm.jpg';
        }
        if (is_file(H . "user/avatar/$id.gif")) {
            $a = "/user/avatar/$id.gif";
        } elseif (is_file(H . "user/avatar/$id.jpg")) {
            $a = "/user/avatar/$id.jpg";
        } elseif (is_file(H . "user/avatar/$id.png")) {
            $a = "/user/avatar/$id.png";
        } else {
            $a = "/user/avatar/$sex";
        }
        
        return "<img src='$a' style='width: {$px}px;height: {$px}px' class='img-circle media-object'/>";
    }

}
