<?php

/* DCMS Special
 * Дата последнего редактирования 18.01.2016
 * Модифицировал densnet
 */

require_once '../sys/inc/start.php';
require_once H . 'sys/inc/compress.php';
require_once H . 'sys/inc/sess.php';
require_once H . 'sys/inc/settings.php';
$temp_set = $set;
require_once H . 'sys/inc/db_connect.php';
require_once H . 'sys/inc/ipua.php';
require_once H . 'sys/inc/fnc.php';
require_once H . 'sys/inc/adm_check.php';
require_once H . 'sys/inc/user.php';

access('adm_set_user', null, 'index.php?' . SID);
adm_check();

$set['title'] = lang('Пользовательские настройки');
require_once H . 'sys/inc/thead.php';

if (isset($_POST['save'])) {
    if ($_POST['guest_select'] == 1 || $_POST['guest_select'] == 0) {
        $temp_set['guest_select'] = intval($_POST['guest_select']);
    }
    $temp_set['reg_select'] = esc($_POST['reg_select']);
    $temp_set['user_online'] = intval($_POST['user_online']);
    $temp_set['guest_online'] = intval($_POST['guest_online']);
    $temp_set['user_reg_time'] = intval($_POST['user_reg_time']);
    $temp_set['p_str'] = intval($_POST['p_str']);
    $temp_set['p_str_set'] = intval($_POST['p_str_set']);

    if (save_settings($temp_set)) {
        admin_log(lang('Настройки'), lang('Пользователи'), lang("Изменение пользовательских настроек"));
        $_SESSION['message'] = lang('Изменения сохранены');

        header("Location: ?");
        exit();
    } else {
        $err = lang('Нет прав для изменения файла настроек');
    }
}

aut();
err();

#Навигация
echo "<div class='list-group-item-null list-group-item-grey'><small>";
echo "<a href='/' class='hint--right' data-hint='" . lang('На главную') . "'><i class='fa fa-home fa-lg'></i></a> <i class='fa fa-angle-right fa-fw'></i> ";
echo "<a href='" . DIR_PANEL . "'>" . lang('Панель управления') . "</a> <i class='fa fa-angle-right fa-fw'></i> ";
echo lang('Пользовательские настройки');
echo "</small></div><br />";

echo "<form class='list-group-item-null' method='post' action='?'>";

echo "<small class='grey'>" . lang('Пунктов на страницу') . ":</small><br />";
echo "<select name='p_str' class='custom-select'>";
echo "<option value='5'" . ($temp_set['p_str'] == 5 ? " selected='selected'" : null) . "> 5 " . lang('пунктов') . "</option>";
echo "<option value='7'" . ($temp_set['p_str'] == 7 ? " selected='selected'" : null) . "> 7 " . lang('пунктов') . "</option>";
echo "<option value='10'" . ($temp_set['p_str'] == 10 ? " selected='selected'" : null) . "> 10 " . lang('пунктов') . "</option>";
echo "<option value='15'" . ($temp_set['p_str'] == 15 ? " selected='selected'" : null) . "> 15 " . lang('пунктов') . "</option>";
echo "<option value='20'" . ($temp_set['p_str'] == 20 ? " selected='selected'" : null) . "> 20 " . lang('пунктов') . "</option>";
echo "<option value='25'" . ($temp_set['p_str'] == 25 ? " selected='selected'" : null) . "> 25 " . lang('пунктов') . "</option>";
echo "<option value='30'" . ($temp_set['p_str'] == 30 ? " selected='selected'" : null) . "> 30 " . lang('пунктов') . "</option>";

echo "</select><br />
<small class='text-primary'>
* Учитывайте! Что чем больше пунктов, тем больше запросов на страницу<br />
* Рекомендуется не более 10 пунктов
</small><br /><br />";

echo "<small class='grey'>" . lang('Дополнительные пункты на страницу') . ":</small><br />\n";
echo "<select name=\"p_str_set\" class='custom-select'>\n";

$sel = (($temp_set['p_str_set'] == 1) ? ' selected="selected"' : NULL);

echo "<option value=\"1\"$sel>Включить</option>\n";

$sel = (($temp_set['p_str_set'] == 0) ? ' selected="selected"' : NULL);

echo "<option value=\"0\"$sel>Отключить</option>\n";
echo "</select>";
echo "<br /><small class='text-primary'>
* Дает возможность юзерам ставить больше 10 пунктов в настройках (max 30)<br />
* Учитывайте! Что чем больше пунктов, тем больше запросов на страницу
</small><br /><br />";

echo "<small class='grey'>" . lang('Режим регистрации') . ":</small><br />";
echo "<select class='custom-select' name='reg_select'>";
echo "<option value='close'>Закрыта</option>\n";

$sel = (($temp_set['reg_select'] == 'open') ? ' selected="selected"' : NULL);

echo "<option value='open'$sel>Открыта</option>\n";

$sel = (($temp_set['reg_select'] == 'open_mail') ? ' selected="selected"' : NULL);

echo "<option value='open_mail'$sel>Открыта + E-mail</option>\n";
echo "</select><br /><br />";

echo "<small class='grey'>" . lang('Время пока юзер считается онлайн') . ":</small> <br />
<select name='user_online' class='custom-select'>
<option value='300'" . ($temp_set['user_online'] == 300 ? " selected='selected'" : null) . "> 5 " . lang('минут') . "</option>
<option value='600'" . ($temp_set['user_online'] == 600 ? " selected='selected'" : null) . "> 10 " . lang('минут') . "</option>
<option value='1200'" . ($temp_set['user_online'] == 1200 ? " selected='selected'" : null) . ">20 " . lang('минут') . "</option>
<option value='1800'" . ($temp_set['user_online'] == 1800 ? " selected='selected'" : null) . "> 30 " . lang('минут') . " </option>
<option value='3600'" . ($temp_set['user_online'] == 3600 ? " selected='selected'" : null) . ">1 " . lang('час') . "</option>
</select><br />
<small class='text-primary'>* желательно ставить не более 20 минут</small><br /><br />";

echo "<small class='grey'>" . lang('Время пока гость считается онлайн') . ":</small> <br />
<select name='guest_online' class='custom-select'>
<option value='300'" . ($temp_set['guest_online'] == 300 ? " selected='selected'" : null) . "> 5 " . lang('минут') . "</option>
<option value='600'" . ($temp_set['guest_online'] == 600 ? " selected='selected'" : null) . "> 10 " . lang('минут') . "</option>
<option value='1200'" . ($temp_set['guest_online'] == 1200 ? " selected='selected'" : null) . ">20 " . lang('минут') . "</option>
<option value='1800'" . ($temp_set['guest_online'] == 1800 ? " selected='selected'" : null) . "> 30 " . lang('минут') . " </option>
<option value='3600'" . ($temp_set['guest_online'] == 3600 ? " selected='selected'" : null) . ">1 " . lang('час') . "</option>
</select><br />
<small class='text-primary'>* желательно ставить не более 20 минут</small><br /><br />";

echo "<small class='grey'>" . lang('Время пока юзер считается новым на сайте') . ":</small><br />
<select name='user_reg_time' class='custom-select'>
<option value='43200'" . ($temp_set['user_reg_time'] == 43200 ? " selected='selected'" : null) . "> 12 " . lang('часов') . "</option>
<option value='86400'" . ($temp_set['user_reg_time'] == 86400 ? " selected='selected'" : null) . "> 1 " . lang('день') . "</option>
<option value='172800'" . ($temp_set['user_reg_time'] == 172800 ? " selected='selected'" : null) . "> 2  " . lang('дня') . "</option>
<option value='259200'" . ($temp_set['user_reg_time'] == 259200 ? " selected='selected'" : null) . "> 3 " . lang('дня') . "</option>
<option value='345600'" . ($temp_set['user_reg_time'] == 345600 ? " selected='selected'" : null) . "> 4 " . lang('дня') . " </option>
<option value='432000'" . ($temp_set['user_reg_time'] == 432000 ? " selected='selected'" : null) . "> 5 " . lang('дней') . "</option>
<option value='518400'" . ($temp_set['user_reg_time'] == 518400 ? " selected='selected'" : null) . "> 6 " . lang('дней') . "</option>
<option value='604800'" . ($temp_set['user_reg_time'] == 604800 ? " selected='selected'" : null) . "> 1 " . lang('неделя') . "</option>
</select><br />
<small class='text-primary'>* пока юзер новый у него особая иконка возле логина</small><br /><br />";


echo "<small class='grey'>" . lang('Режим гостя') . ":</small><br />";
echo "<select class='custom-select' name='guest_select'>";
echo "<option value='0'>Открыто все</option>\n";

$sel = (($temp_set['guest_select'] == '1') ? ' selected="selected"' : NULL);

echo "<option value='1'$sel>Закрыто все *</option>\n";
echo "</select><br />";

echo "<small class='text-primary'>* остаются открытыми регистрация и авторизация</small><br /><br />\n";

$doc->Button('btn btn-success btn-sm', 'save', 'save', 'Сохранить');
echo "</form>\n";

require_once H . 'sys/inc/tfoot.php';
