<?php

#Проверяем версию PHP
version_compare(PHP_VERSION, '5.3.10', '>=') or die('Требуется PHP >= 5.3.10');

#автоматическая загрузка классов

function __autoload($class_name) {
    $path = H . '/sys/classes/' . strtolower($class_name) . '.class.php';
    if (file_exists($path)) {
        include_once ($path);
    }
}

define("H", $_SERVER["DOCUMENT_ROOT"] . '/');

ini_set('display_errors', 'On'); // сообщения с ошибками будут показываться
error_reporting(E_ALL); // E_ALL - отображаем ВСЕ ошибки
#Ставим ограничение для выполнения скрипта на 60 сек
if (function_exists('set_time_limit')) {
    set_time_limit(60);
}
if (function_exists('ini_set')) {
    ini_set('date.timezone', 'Europe/Moscow'); #устанавливаем Московскую временную зону по умолчанию
    ini_set('register_globals', false); #вырубаем глобальные переменные
    ini_set('session.use_cookies', true); #используем куки для сессий
    ini_set('session.use_trans_sid', true); #используем url для передачи сессий
    ini_set('arg_separator.output', "&amp;"); #разделитель переменных в url (для соответствия с xml)
    ini_set("gd.jpeg_ignore_warning", 1);
}

// принудительно вырубаем глобальные переменные
if (ini_get('register_globals')) {
    $allowed = array('_ENV' => 1, '_GET' => 1, '_POST' => 1, '_COOKIE' => 1, '_FILES' => 1, '_SERVER' => 1, '_REQUEST' => 1, 'GLOBALS' => 1);
    foreach ($GLOBALS as $key => $value) {
        if (!isset($allowed[$key])) {
            unset($GLOBALS[$key]);
        }
    }
}

#время запуска скрипта
list($msec, $sec) = explode(chr(32), microtime()); // время запуска скрипта
$conf['headtime'] = $sec + $msec;

define('MKTIME', mktime(0, 0, 0));
define('TIME', time());
define('USE_FFMPEG', class_exists('ffmpeg_movie'));
define('USE_GD', function_exists('gd_info'));
define('USE_MBSTRING', function_exists('mb_get_info'));
define('USE_ICONV', function_exists('iconv'));
define('USE_MCRYPT', function_exists('mcrypt_cbc'));
define('USE_MYSQL', function_exists('mysql_info'));
define('SESSION_PASSWORD_USER', 'DCMS_SESSION_PASSWORD_USER');
define('COOKIE_USER_PASSWORD', 'DCMS_COOKIE_USER_PASSWORD');

#Пути папок, удобно при переименовании или перемещении директорий
define('DIR_PANEL', "/panel/");
define('DIR_PUBLIC', "/modules/public/");

$time = time();
$ftime = mktime(0, 0, 0);
$phpvervion = explode('.', phpversion());
$conf['phpversion'] = $phpvervion[0];

define('TIME_TODAY', mktime(0, 0, 0)); #на начало текущих суток
define('SET_TIME_LIMIT', function_exists('set_time_limit'));

$upload_max_filesize = ini_get('upload_max_filesize');
if (preg_match('#([0-9]*)([a-z]*)#i', $upload_max_filesize, $varrs)) {
    if ($varrs[2] == 'M') {
        $upload_max_filesize = $varrs[1] * 1048576;
    } elseif ($varrs[2] == 'K') {
        $upload_max_filesize = $varrs[1] * 1024;
    } elseif ($varrs[2] == 'G') {
        $upload_max_filesize = $varrs[1] * 1024 * 1048576;
    }
}

$doc = new document();
