<?php

include_once '../sys/inc/start.php';
$doc = new document();
$doc->title = __('Форум - Категории');


$listing = new ui_components();
$listing->ui_menu = true;

if (false === ($new_themes = cache_counters::get('forum.new_themes.' . $user->group))) {
    $res = $db->prepare("SELECT COUNT(*) FROM `forum_themes` AS `th` INNER JOIN `forum_topics` AS `tp` ON `tp`.`id` = `th`.`id_topic` AND `tp`.`theme_view` = ? LEFT JOIN `forum_categories` AS `cat` ON `cat`.`id` = `th`.`id_category` WHERE `th`.`group_show` <= ? AND `tp`.`group_show` <= ? AND `cat`.`group_show` <= ? AND `th`.`time_create` > ?");
    $res->execute(Array(1, $user->group, $user->group, $user->group, NEW_TIME));
    $new_themes = $res->fetchColumn();
    cache_counters::set('forum.new_themes.' . $user->group, $new_themes, 20);
}
if (false === ($new_posts = cache_counters::get('forum.new_posts.' . $user->group))) {
    $res = $db->prepare("SELECT COUNT(DISTINCT(`msg`.`id_theme`)) FROM `forum_messages` AS `msg` LEFT JOIN `forum_themes` AS `th` ON `th`.`id` = `msg`.`id_theme` INNER JOIN `forum_topics` AS `tp` ON `tp`.`id` = `th`.`id_topic` AND `tp`.`theme_view` = ? LEFT JOIN `forum_categories` AS `cat` ON `cat`.`id` = `th`.`id_category` WHERE `th`.`group_show` <= ? AND `tp`.`group_show` <= ? AND `cat`.`group_show` <= ? AND `msg`.`group_show` <= ? AND `msg`.`time` > ?");
    $res->execute(Array(1, $user->group, $user->group, $user->group, $user->group, NEW_TIME));
    $new_posts = $res->fetchColumn();
    cache_counters::set('forum.new_posts.' . $user->group, $new_posts, 20);
}
if (false === ($my_themes = cache_counters::get('forum.my_themes.' . $user->id))) {
    $res = $db->prepare("SELECT COUNT(DISTINCT(`msg`.`id_theme`)) FROM `forum_messages` AS `msg` LEFT JOIN `forum_themes` AS `th` ON `th`.`id` = `msg`.`id_theme` LEFT JOIN `forum_topics` AS `tp` ON `tp`.`id` = `th`.`id_topic` LEFT JOIN `forum_categories` AS `cat` ON `cat`.`id` = `th`.`id_category` WHERE `th`.`id_autor` = ? AND `th`.`group_show` <= ? AND `tp`.`group_show` <= ? AND `cat`.`group_show` <= ? AND `msg`.`group_show` <= ? AND `msg`.`id_user` <> ? AND `msg`.`time` > ?");
    $res->execute(Array($user->id, $user->group, $user->group, $user->group, $user->group, $user->id, NEW_TIME));
    $my_themes = $res->fetchColumn();
    cache_counters::set('forum.my_themes.' . $user->id, $my_themes, 20);
}

$post = $listing->post();
$post->head = '
    <div class="ui icon menu">
            
        <span data-tooltip="' . __('Поиск') . '" data-position="bottom left">
            <a class="item" href="search.php"><i class="fa fa-search fa-fw"></i></a>
        </span>
            
        <span data-tooltip="' . __('Новые темы') . '" data-position="bottom left">
            <a class="item" href="last.themes.php"><i class="fa fa-asterisk fa-fw"></i> ' . ($new_themes ? "<span style='color: green'>+$new_themes</span>" : null) . '</a>
        </span>
            
        <span data-tooltip="' . __('Обновленные темы') . '" data-position="bottom left">
            <a class="item" href="last.posts.php"><i class="fa fa-file-text-o fa-fw"></i> ' . ($new_posts ? "<span style='color: green'>+$new_posts</span>" : null) . '</a>
        </span>
            
        ' . ($user->id ? '
            <span data-tooltip="' . __('Мои темы') . '" data-position="bottom left">
                <a class="item" href="my.themes.php"><i class="fa fa-list-alt fa-fw"></i> ' . ($my_themes ? "<span style='color: green'>+$my_themes</span>" : null) . '</a>
            </span>
        ' : null) . '
                
        ' . ($user->group >= 5 ? '
            <span data-tooltip="' . __('Статистика') . '" data-position="bottom left">
                <a class="item" href="stat.php"><i class="fa fa-pie-chart fa-fw"></i></a>
            </span>
        ' : null) . '
    </div>';

$listing->display();

$listing = new listing();

$res = $db->prepare("SELECT COUNT(*) FROM `forum_categories` WHERE `group_show` <= ?");
$res->execute(Array($user->group));
$pages = new pages();
$pages->posts = $res->fetchColumn();

$q = $db->prepare("SELECT * FROM `forum_categories` WHERE `group_show` <= ? ORDER BY `position` ASC LIMIT " . $pages->limit);
$q->execute(Array($user->group));
while ($category = $q->fetch()) {
    $res = $db->prepare("SELECT COUNT(*) FROM `forum_topics` WHERE `id_category` = ? AND `group_show` <= ?");
    $res->execute(Array($category['id'], $user->group));
    $topicCount = $res->fetchColumn();

    $post = $listing->post();
    $post->url = "category.php?id=$category[id]";
    $post->title = text::toValue($category['name']);
    $post->icon('object-group');
    $post->post = text::for_opis($category['description']);
    $post->counter = $topicCount;
}

$listing->display(__('Доступных Вам категорий нет'));

$pages->display('?'); // вывод страниц

$listing = new ui_components();
$listing->ui_menu = true;
$post = $listing->post();
$post->head = '
    <div class="ui icon menu">
        ' . ($user->group >= 5 ? '
            <span data-tooltip="' . __('Создать категорию') . '" data-position="bottom left">
                <a class="item" href="category.new.php"><i class="fa fa-plus fa-fw"></i> ' . __('Категория') . '</a>
            </span>
            
            <span data-tooltip="' . __('Порядок категорий') . '" data-position="bottom left">
                <a class="item" href="categories.sort.php"><i class="fa fa-list-ol fa-fw"></i> ' . __('Порядок') . '</a>
            </span>
        ' : null) . '
    </div>';

$listing->display();
