<?php

include_once '../sys/inc/start.php';
$doc = new document(1); // инициализация документа для браузера
$doc->setTitle(__('Общие настройки'));

if (isset($_POST['save'])) {
    // количество пунктов на страницу
    if (!empty($_POST['items_per_page'])) {
        $ipp = (int) $_POST['items_per_page'];
        if ($ipp >= 5 && $ipp <= 99) {
            $user->items_per_page = $ipp;
        } else {
            $doc->addError(__('Недопустимое количество пунктов на страницу'));
        }
    }
    // временной сдвиг
    if (isset($_POST['time_shift'])) {
        $ipp = (int) $_POST['time_shift'];
        if ($ipp >= - 12 && $ipp <= 12) {
            $user->time_shift = $ipp;
        } else {
            $doc->addError(__('Недопустимое время'));
        }
    }

    $doc->addMessage(__('Изменения сохранены'));
}

$form = new form('?' . passgen());
$form->text('items_per_page', __('Пунктов на страницу (%s) [5-99]', $dcms->browser_type), $user->items_per_page);

$options = array(); // Врeменной сдвиг
for ($i = - 12; $i < 12; $i++) {
    $options[] = array($i, date('G:i', TIME + $i * 60 * 60), $user->time_shift == $i);
}
$form->bbcode('[b]' . __('Мое время') . '[/b]', FALSE);
$form->select('time_shift', false, $options, false);
$form->button(__('Сохранить изменения'), 'save', false, 'tiny ui green labeled fa button', 'fa fa-save fa-fw');
$form->display();

$doc->addBreadcrumb(__('Личное меню'), '/menu.user.php');
