<?php

include_once '../sys/inc/start.php';
$doc = new document ();
$doc->setTitle(__('Фотоальбомы'));


if (!empty($_GET ['id'])) {
    $ank = new user((int) $_GET ['id']);
} else {
    $ank = $user;
}

if (!$ank->group) {
    $doc->showAccessDenied(__('Ошибка пользователя'));
}

// папка фотоальбомов пользователей
$photos = new files(FILES . '/.photos');
// папка альбомов пользователя
$albums_path = FILES . '/.photos/' . $ank->id;

if (!@is_dir($albums_path)) {
    if (!$albums_dir = $photos->mkdir($ank->login, $ank->id)) {
        $doc->showAccessDenied(__('Не удалось создать папку под фотоальбомы пользователя'));
    }
    $albums_dir->group_show = 0;
    $albums_dir->group_write = max($ank->group, 2);
    $albums_dir->group_edit = max($ank->group, 4);
    $albums_dir->id_user = $ank->id;
    unset($albums_dir);
}

$albums_dir = new files($albums_path);

if (empty($_GET ['album']) || !$albums_dir->is_dir($_GET ['album'])) {
    $doc->addError(__('Запрошеный альбом не существует'));
    $doc->addBreadcrumb(__('К альбомам %s', $name), 'albums.php?id=' . $ank->id);
    header('Refresh: 1; url=albums.php?id=' . $ank->id);
    exit();
}

$album_name = (string) $_GET ['album'];
$album = new files($albums_path . '/' . $album_name);
$doc->setTitle($album->runame);

$doc->setDescription(__('Фотоальбом пользователя %s:%s', $ank->login, $album->runame));
$doc->addKeyword($album->runame);
$doc->addKeyword($ank->login);

if (!empty($_GET ['act']) && $ank->id == $user->id) {
    switch ($_GET ['act']) {
        case 'prop' :
            $doc->setTitle($album->runame . ' - ' . __('Параметры'));

            if (!empty($_POST ['prop'])) {
                if ($album->id_user = $user->id) {

                    if (isset($_POST['group_show'])) {
                        $album->group_show = $_POST['group_show'];
                    }

                    $album->runame = text::input_text(@$_POST['name']);
                    $album->description = text::input_text(@$_POST['description']);
                    $doc->addMessage(__('Изменения сохранены'));
                    $doc->addBreadcrumb(__('Альбомы %s', $ank->login), 'albums.php?id=' . $ank->id);
                } else {
                    $doc->addError(__('Не удалось сменит название альбома'));
                    $doc->addBreadcrumb(__('В альбом'), '?id=' . $ank->id . '&amp;album=' . urlencode($album->name));
                    $doc->addBreadcrumb(__('Альбомы %s', $ank->login), 'albums.php?id=' . $ank->id);
                }
            }

            $form = new form(new url(null, array('act' => 'prop')));
            $form->text('name', 'Название', $album->runame);
            $form->textarea('description', 'Описание', $album->description);
            $options = array();
            $options [] = array('0', __('Все'), $album->group_show == "0");
            $options [] = array('1', __('Зарегистрированные'), $album->group_show == "1");
            $form->select('group_show', __('Кто видит альбом'), $options);
            $form->block('<input type="submit" name="prop" value="' . __('Сохранить') . '" class="tiny ui blue button" />');
            $form->display();

            $doc->addBreadcrumb(__('В альбом'), '?id=' . $ank->id . '&amp;album=' . urlencode($album->name));
            exit();
        case 'photo_add' :
            $doc->setTitle($album->runame . ' - ' . __('Выгрузка фото'));

            if (!empty($_FILES ['file'])) {
                if ($_FILES ['file'] ['error']) {
                    $doc->addError(__('Ошибка при загрузке'));
                } elseif (!$_FILES ['file'] ['size']) {
                    $doc->addError(__('Содержимое файла пусто'));
                } elseif (!preg_match('#\.jpe?g$#ui', $_FILES ['file'] ['name'])) {
                    $doc->addError(__('Неверное расширение файла'));
                } elseif (!$img = @imagecreatefromjpeg($_FILES ['file'] ['tmp_name'])) {
                    $doc->addError(__('Файл не является изображением JPEG'));
                } elseif (@imagesx($img) < 128) {
                    $doc->addError(__('Ширина изображения должна быть не менее 128 px'));
                } elseif (@imagesy($img) < 128) {
                    $doc->addError(__('Высота изображения должна быть не менее 128 px'));
                } else {
                    if ($files_ok = $album->filesAdd(array($_FILES ['file'] ['tmp_name'] => $_FILES ['file'] ['name']))) {
                        $files_ok [$_FILES ['file'] ['tmp_name']]->id_user = $ank->id;
                        $files_ok [$_FILES ['file'] ['tmp_name']]->group_edit = max($ank->group, $album->group_write, 2);

                        unset($files_ok);
                        $doc->addMessage(__('Фотография "%s" успешно добавлена', $_FILES ['file'] ['name']));
                    } else {
                        $doc->addError(__('Не удалось сохранить выгруженный файл'));
                    }
                }
            }

            $form = new form(new url(null, array('act' => 'photo_add')));
            $form->file('file', __('Фотография') . ' (*.jpg)');
            $form->button(__('Выгрузить'));
            $form->display();

            $doc->addBreadcrumb(__('В альбом'), '?id=' . $ank->id . '&amp;album=' . urlencode($album->name));
            exit();
        case 'delete' :
            $doc->setTitle($album->runame . ' - ' . __('Удаление'));

            if (!empty($_POST ['delete'])) {

                if ($album->delete()) {
                    $doc->addMessage(__('Альбом успешно удален'));
                    $doc->addBreadcrumb(__('Альбомы %s', $ank->login), 'albums.php?id=' . $ank->id);
                    header('Refresh: 1; url=albums.php?id=' . $ank->id . '&' . passgen());
                } else {

                    $doc->addError(__('Не удалось удалить альбом'));
                    $doc->addBreadcrumb(__('В альбом'), '?id=' . $ank->id . '&amp;album=' . urlencode($album->name));
                    $doc->addBreadcrumb(__('Альбомы %s', $ank->login), 'albums.php?id=' . $ank->id);
                    header('Refresh: 1; url=?id=' . $ank->id . '&album=' . urlencode($album->name) . '&' . passgen());
                }
                exit();
            }

            $form = new form(new url(null, array('act' => 'delete')));
            $form->block('<div class="ui mini yellow message">' . __('Все данные, относящиеся к данному альбому будут безвозвратно удалены.') . '</div>');
            $form->block('<input type="submit" name="delete" value="' . __('Удалить альбом') . '" class="tiny ui blue button" />');

            $form->display();

            $doc->addBreadcrumb(__('В альбом'), '?id=' . $ank->id . '&amp;album=' . urlencode($album->name));
            exit();
    } // switch
}

$list = $album->getList('time_add:desc'); // получение содержимого папки альбома
$files = $list ['files']; // получение только файлов

$pages = new pages(count($files));
$start = $pages->my_start();
$end = $pages->end();

if ($ank->id == $user->id) {
    $listing = new ui_components();

    $post = $listing->post();
    $post->head = '
        <div class="ui icon menu">
            <span data-tooltip="' . __('Выгрузить фото') . '" data-position="bottom left">
                <a class="item" href="?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;act=photo_add"><i class="fa fa-camera fa-fw"></i></a>
            </span>
            
            <span data-tooltip="' . __('Параметры альбома') . '" data-position="bottom left">
                <a class="item" href="?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;act=prop"><i class="fa fa-cog fa-fw"></i></a>
            </span>
            
            <span data-tooltip="' . __('Удалить альбом') . '" data-position="bottom left">
                <a class="item" href="?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;act=delete"><i class="fa fa-trash-o fa-fw"></i></a>
            </span>
        </div>';

    $listing->display();
}

$listing = new ui_components();

$display = false;

echo "<div class='ui segment'>";
echo "<div class='ui tiny images'>";
for ($i = $start; $i < $end && $i < $pages->posts; $i++) {
    $display = true;

    echo "<a href='photo.php?id=$ank->id&amp;album=" . urlencode($album->name) . "&amp;photo=" . urlencode($files [$i]->name) . "'>";
    echo "<img class='ui image' src='" . $files[$i]->image() . "' />";
    //$post->title = text::toValue($files[$i]->runame);

    if ($comments = $files [$i]->comments) {
        //$post->content[] = __('%s комментари' . misc::number($comments, 'й', 'я', 'ев'), $comments);
    }

    if ($properties = $files [$i]->properties) {
        // Параметры файла (только основное)
        //$post->content[] = $properties;
    }
    echo "</a>";
}

echo "</div>";

if ($display) {
    $listing->post();
}

$listing->display(__('Фотографии отсутствуют'));

echo "</div>";

$pages->display('?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;'); // вывод страниц

$doc->addBreadcrumb(__('Альбомы %s', $ank->login), 'albums.php?id=' . $ank->id);
