<?php

class auth
{

    static protected $_user = null;
    protected function __construct(){

    }

    static protected function _initUser()
    {
        if (!empty($_SESSION [SESSION_ID_USER])) {
            // авторизация по сессии
            self::$_user = new user($_SESSION [SESSION_ID_USER]);
        } elseif (!empty($_COOKIE [COOKIE_ID_USER]) && !empty($_COOKIE [COOKIE_USER_PASSWORD]) && !isset($_GET['login_from_cookie']) && $_SERVER ['SCRIPT_NAME'] !== '/pages/login.php' && $_SERVER ['SCRIPT_NAME'] !== '/pages/captcha.php') {
            // авторизация по COOKIE (получение сессии, по которой пользователь авторизуется)
            header('Location: /login.php?login_from_cookie&return=' . URL);
            exit;
        } else {
            // пользователь будет являться гостем
            self::$_user = new user();
        }

        if (self::isGuest() && isset($_SESSION [SESSION_ID_USER])) {
            unset($_SESSION [SESSION_ID_USER]);
        }
    }

    static public function login($login, $password, $saveToCookie = false)
    {
        $q = db::me()->prepare("SELECT `id`, `password` FROM `users` WHERE `login` = ? LIMIT 1");
        $q->execute(Array($login));

        if (!$row = $q->fetch()) {
            throw new Exception(__("Пользователь с указанным логином не зарегистрирован"));
        }

        if (crypt::hash($password, dcms::getInstance()->salt) !== $row['password']) {
            cache_aut_failture::set(dcms::getInstance()->ip_long, true, 600);
            throw new Exception(__("Не правильный пароль"));
        }

        $user = new user($row['id']);

        if ($user->a_code) {
            throw new Exception(__("Аккаунт не активирован"));
        }

        if ($user->recovery_password) {
            // если пользователь авторизовался, то ключ для восстановления ему больше не нужен
            $user->recovery_password = '';
        }
        $_SESSION[SESSION_ID_USER] = $user->id;

        self::$_user = $user;

        if ($saveToCookie) {
            setcookie(COOKIE_ID_USER, $user->id, TIME + 60 * 60 * 24 * 365);
            setcookie(COOKIE_USER_PASSWORD, crypt::encrypt($password, dcms::getInstance()->salt_user),
                TIME + 60 * 60 * 24 * 365);
        }
    }

    static public function logout()
    {
        $res = db::me()->prepare("DELETE FROM `users_online` WHERE `id_user` = ?;");
        $res->execute(Array(self::getUser()->id));

        self::$_user = new user();

        setcookie(COOKIE_ID_USER);
        setcookie(COOKIE_USER_PASSWORD);
        unset($_SESSION);
        session_destroy();

        /* Инициализация механизма сессий  */
        session_name(SESSION_NAME) or die(__('Невозможно инициализировать сессии'));
        @session_start() or die(__('Невозможно инициализировать сессии'));
    }

    /**
     * @return user
     */
    static public function getUser()
    {
        if (is_null(self::$_user)) {
            self::_initUser();
        }
        return self::$_user;
    }

    /**
     * @return bool
     */
    static public function isGuest()
    {
        return !self::getUser()->id;
    }

    public static function isLogged()
    {
        return !!self::getUser()->id;
    }

} 