<?php
/**
 * @var $model document
 */
?>

<!DOCTYPE html>
<html ng-app="Dcms">
    <head>
        <title><?= $model->getTitle() ?></title>

        <link rel="shortcut icon" href="/sys/images/icons/special.png"/>

        <?php $model->displayStyleSheetsTags(); ?>
        <?php $model->displayScriptsTags(); ?>
        <?php $model->displayMetaDescription(); ?>
        <?php $model->displayMetaKeywords(); ?>

        <meta name="theme-color" content="#0084B4" />

        <noscript>
        <meta http-equiv="refresh" content="0; URL=/pages/bad_browser.html"/>
        </noscript>

        <script>
            (function () {
            var getIeVer = function () {
            var rv = - 1; // Return value assumes failure.
            if (navigator.appName === 'Microsoft Internet Explorer') {
            var ua = navigator.userAgent;
            var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
            if (re.exec(ua) !== null)
                    rv = parseFloat(RegExp.$1);
            }
            return rv;
            };
            var ver = getIeVer();
            if (ver !== - 1 && ver < 9) {
            window.location.href = "/pages/bad_browser.html";
            }
            })();
        </script>

        <meta name="generator" content="DCMS Special <?= dcms::getInstance()->version ?>"/>

        <script>
            user = <?= json_encode(auth::getUser()->getCustomData(array('id', 'group', 'mail_new_count', 'not_new_count', 'friend_new_count', 'nick'))) ?>;
            translates = {
            bbcode_b: '<?= __('Текст жирным шрифтом') ?>',
                    bbcode_i: '<?= __('Текст курсивом') ?>',
                    bbcode_u: '<?= __('Подчеркнутый текст') ?>',
                    bbcode_img: '<?= __('Вставка изображения') ?>',
                    bbcode_php: '<?= __('Выделение PHP-кода') ?>',
                    bbcode_big: '<?= __('Увеличенный размер шрифта') ?>',
                    bbcode_small: '<?= __('Уменьшенный размер шрифта') ?>',
                    bbcode_gradient: '<?= __('Цветовой градиент') ?>',
                    bbcode_hide: '<?= __('Скрытый текст') ?>',
                    bbcode_spoiler: '<?= __('Свернутый текст') ?>',
                    smiles: '<?= __('Смайлы') ?>',
                    form_submit_error: '<?= __('Ошибка связи...') ?>',
                    friends: '<?= __("Друзья") ?>',
                    mail: '<?= __("Сообщения") ?>',
                    notification: '<?= __("Уведомления") ?>',
                    error: '<?= __('Неизвестная ошибка') ?>'
            };
            codes = [
            {Text: 'B', Title: translates.bbcode_b, Prepend: '[b]', Append: '[/b]'},
            {Text: 'I', Title: translates.bbcode_i, Prepend: '[i]', Append: '[/i]'},
            {Text: 'U', Title: translates.bbcode_u, Prepend: '[u]', Append: '[/u]'},
            {Text: 'BIG', Title: translates.bbcode_big, Prepend: '[big]', Append: '[/big]'},
            {Text: 'Small', Title: translates.bbcode_small, Prepend: '[small]', Append: '[/small]'},
            {Text: 'IMG', Title: translates.bbcode_img, Prepend: '[img]', Append: '[/img]'},
            {Text: 'PHP', Title: translates.bbcode_php, Prepend: '[php]', Append: '[/php]'},
            {Text: 'SPOILER', Title: translates.bbcode_spoiler, Prepend: '[spoiler title=""]', Append: '[/spoiler]'},
            {Text: 'HIDE', Title: translates.bbcode_hide, Prepend: '[hide group="1" balls="1"]', Append: '[/hide]'}
            ];
        </script>
        <style type="text/css">
            .ng-hide {
                display: none !important;
            }
        </style>
    </head>
    <body ng-controller="DcmsCtrl">

        <script src="https://cdn.jsdelivr.net/emojione/2.2.6/lib/js/emojione.min.js"></script>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/emojione/2.2.6/assets/css/emojione.min.css"/>

        <audio id="audio_notify" preload="auto" class="ng-hide">
            <source src="/sys/themes/.common/notify.mp3" />
            <source src="/sys/themes/.common/notify.ogg" />
        </audio>
        <div id="main">
            <div id="top_part">
                <header id="header">
                    <div class="topbar">
                        <div class="global-nav">
                            <div class="container">
                                <div role="navigation" style="display: inline-block;">
                                    <ul class="nav" id="global-actions">

                                        <li id="breadcrumbs">
                                            <a href="#">
                                                <i class="fa fa-sitemap fa-lg fa-fw"></i>
                                                <span class="text"><?= __('Навигация') ?></span>
                                            </a>
                                        </li>

                                        <div class="ui popup bottom left transition hidden grid">
                                            <div class="ui link list">
                                                <a class="item" href='/'><?= __("Главная") ?></a><br />
                                                <?php echo $model->displayBreadcrumbs('<a class="item" href="{$url}">{$name}</a><br />'); ?>
                                            </div>
                                        </div>

                                        <script type="text/javascript">
        $('ul.nav li#breadcrumbs').popup({inline : true, hoverable  : true, position   : 'bottom left', delay: {show: 300, hide: 5000}});
                                        </script>

                                        <?php if (auth::isLogged()) { ?>
                                            <li>
                                                <a href="/my.notification.php" ng-show="+ user.not_new_count" class='ng-hide'>
                                                    <i class="fa fa-bell fa-lg fa-fw"></i>
                                                    <span class="text" ng-bind="str.notification"><?= __('Уведомления') ?></span>
                                                </a>
                                            </li>
                                            <li class="dm-nav">
                                                <a href="/my.mail.php?from=new" ng-show="+ user.mail_new_count" class='ng-hide'>
                                                    <i class="fa fa-envelope fa-lg fa-fw"></i>
                                                    <span class="text" ng-bind="str.mail"><?= __('Сообщения') ?></span>
                                                </a>
                                            </li>
                                            <li>
                                                <a href="/my.friends.php?act=application" ng-show="+ user.friend_new_count" class='ng-hide'>
                                                    <i class="fa fa-handshake-o fa-lg fa-fw"></i>
                                                    <span class="text" ng-bind="str.friends"><?= __('Друзья') ?></span>
                                                </a>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>

                                <div class="pull-right" style="display: inline-block;">
                                    <ul class="nav right-actions">
                                        <?php
                                        # Для пользователя авторизованного
                                        if (auth::isLogged()) {
                                            ?>
                                            <li class="dropdown session">
                                                <div class="ui right pointing dropdown" id="profile">
                                                    <span data-variation="tiny" data-inverted="" data-tooltip='<?= __('Профиль и настройки') ?>' data-position='bottom center'>
                                                        <a href="#" class="btn dropdown-toggle" id="profile">
                                                            <img class="size32" src="<?= auth::getUser()->getAvatar(32) ?>" alt="<?= auth::getUser()->login ?>">
                                                        </a>
                                                    </span>

                                                    <div class="menu">
                                                        <a class="active item" href="/profile.view.php"><?= __('Мой профиль') ?></a>
                                                        <a class="item" href="/menu.user.php"><?= __('Личное меню') ?></a>
                                                        <a class="item" href="/profile.edit.php"><?= __('Обновить анкету') ?></a>
                                                        <div class="divider"></div>
                                                        <a class="item" href="/modules/shop/"><b style="color: orange"><?= __('Магазин') ?></b></a>
                                                        <a class="item" href="/log.user_aut.php"><?= __('Журнал авторизаций') ?></a>
                                                        <div class="item"><i class="fa fa-caret-left icon left"></i> <?= __('Настройки') ?> 
                                                            <div class="left menu">
                                                                <a class="item" href="/settings.common.php"><?= __('Общие') ?></a>
                                                                <a class="item" href="/settings.language.php"><?= __('Язык') ?></a>
                                                                <a class="item" href="/settings.private.php"><?= __('Приватность') ?></a>
                                                                <a class="item" href="/settings.themes.php"><?= __('Тема оформления') ?></a>
                                                                <a class="item" href="/my.avatar.php"><?= __('Обновить аватар') ?></a>
                                                                <a class="item" href="/my.fon.php"><?= __('Фон профиля') ?></a>
                                                            </div>
                                                        </div>
                                                        <div class="divider"></div>
                                                        <a class="item" href="/exit.php"><?= __('Выйти') ?></a>
                                                    </div>
                                                </div>
                                                <script>
                                                    $('#profile').dropdown();
                                                </script>

                                            </li>
                                            <?php
                                        }
                                        # Для гостей
                                        if (auth::isGuest()) {
                                            ?>
                                            <ul class="nav" id="global-actions">
                                                <li>
                                                    <a href="/login.php?return={{URL}}">
                                                        <i class="fa fa-sign-in fa-lg fa-fw"></i>
                                                        <span class="text"><?= __('Авторизация') ?></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="/reg.php?return={{URL}}">
                                                        <i class="fa fa-user-plus fa-lg fa-fw"></i>
                                                        <span class="text"><?= __('Регистрация') ?></span>
                                                    </a>
                                                </li>
                                            </ul>
                                        <?php } ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $model->displaySection('header'); ?>
                </header>

                <div id="middle" class="body_width_limit clearfix">
                    <div id="left_column">
                        <?php $model->displaySection('left_column'); ?>
                    </div>
                    <div id="content">
                        <div id="messages">
                            <?php $model->displayErrors(); ?>
                            <?php $model->displayMessages(); ?>
                            <?php $model->displayInformations(); ?>
                        </div>
                        <div class="body_width_limit clearfix">
                            <div class="ui secondary segment" style="margin-bottom: 10px;">
                                <div class="active section"><?= $model->getTitle(); ?></div>
                            </div>
                        </div>

                        <?php if ($model->hasTabs()) { ?>
                            <div id="tabs">
                                <?php $model->displayTabs(); ?>
                            </div>
                        <?php } ?>

                        <?php $model->displaySection('content'); ?>
                    </div>
                </div>
                <div id="empty"></div>
            </div>
            <div id="footer">
                <div class="body_width_limit">
                    <span id="copyright">
                        <?= $copyright ?>
                    </span>
                    <span id="language">
                        <?= __("Язык") ?>:<a href='/language.php?return={{URL}}'><i class="<?= $lang->icon ?> flag"></i> <?= $lang->name ?></a>
                    </span>
                    <span id="generation">
                        <?= __("Время генерации страницы: %s сек", $model->getGenerationTime()) ?>
                    </span>
                </div>
            </div>
        </div>
    </body>
</html>