<?php
/**
 * @var $model document
 */
?>

<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?= $lang->xml_lang ?>">
    <head>
        <title><?= $model->getTitle() ?></title>
        <link rel="shortcut icon" href="/sys/images/icons/special.png"/>
        <meta http-equiv="content-Type" content="application/xhtml+xml; charset=utf-8"/>
        <meta name="generator" content="DCMS Special <?= $dcms->version ?>"/>
        <?php $model->displayStyleSheetsTags(); ?>
        <?php $model->displayScriptsTags(); ?>
        <?php $model->displayMetaDescription(); ?>
        <?php $model->displayMetaKeywords(); ?>
        <style type="text/css">
            .hide {
                display: none !important;
            }
        </style>
    </head>
    <body class="theme_light theme_light_light">
        <script src="https://cdn.jsdelivr.net/emojione/2.2.6/lib/js/emojione.min.js"></script>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/emojione/2.2.6/assets/css/emojione.min.css"/>

        <?php $this->display('inc.title.tpl') ?>
        <?php $model->displaySection('after_title') ?>
        <?php $this->display('inc.user.tpl') ?>

        <div id="tabs">
            <?php $model->displayTabs() ?>
        </div>
        <?php $model->displaySection('before_content') ?>
        <div id="content">
            <link rel="stylesheet" href="<?= $path ?>/css/message.css" type="text/css"/>

            <div id="messages">
                <?php $model->displayErrors(); ?>
                <?php $model->displayMessages(); ?>
                <?php $model->displayInformations(); ?>   
            </div>
            <?php $model->displaySection('content') ?>
        </div>
        <?php $model->displaySection('after_content') ?>
        <?php $this->display('inc.foot.tpl') ?>
        <div id="foot">
            <?= __("Язык") ?>: <a href='/pages/language.php?return=<?= URL ?>' id="language"><?= $lang->name ?></a><br/>
            <?= __("Время генерации страницы: %s сек", $model->getGenerationTime()) ?><br/>
            <?= $copyright ?>
        </div>
    </body>
</html>