<?php
/**
 * @var $model document
 */
?>

<!DOCTYPE html>
<html>
    <head>
        <title><?= $model->getTitle() ?></title>
        <link rel="shortcut icon" href="/sys/images/icons/special.png"/>
        <?php $model->displayStyleSheetsTags(); ?>
        <?php $model->displayScriptsTags(); ?>
        <?php $model->displayMetaDescription(); ?>
        <?php $model->displayMetaKeywords(); ?>

        <meta name="viewport" content="minimum-scale=1.0,initial-scale=1.0,maximum-scale=1.0,user-scalable=no"/>
        <meta name="theme-color" content="#0084B4" />
        <meta name="generator" content="DCMS Special <?= $dcms->version ?>"/>
        <script>
            window.translate = {
                'friends': "<?= __("Друзья") ?>",
                'mail': "<?= __("Почта") ?>",
                'notification': "<?= __("Уведомления") ?>",
                'user_menu': "<?= __("Личное меню") ?>",
                'auth': "<?= __("Авторизация") ?>",
                'reg': "<?= __("Регистрация") ?>",
                'rating_down_message': '<?= __('Подтвердите понижение рейтинга сообщения.') . ($dcms->forum_rating_down_balls ? "\\n" . __('Будет списано баллов: %s', $dcms->forum_rating_down_balls) : '') ?>'
            };

            window.user = <?= json_encode($user->getCustomData(array('id', 'group', 'friend_new_count', 'mail_new_count', 'not_new_count', 'login'))) ?>;
            window.URL = "<?= URL ?>";
        </script>

        <script src="<?= $path ?>/js/inputInsert.js"></script>
        <script src="<?= $path ?>/js/user.js"></script>
        <script src="<?= $path ?>/js/common.js"></script>
        <script src="<?= $path ?>/js/ajaxForm.js" async="async"></script>
        <script src="<?= $path ?>/js/smiles.js" async="async"></script>
        <script src="<?= $path ?>/js/listing.js" async="async"></script>
    </head>

    <body class="">
        <audio id="audio_notify">
            <source src="/sys/themes/.common/notify.mp3"/>
            <source src="/sys/themes/.common/notify.m4r"/>
            <source src="/sys/themes/.common/notify.aac"/>
            <source src="/sys/themes/.common/notify.ogg"/>
        </audio>
        <script src="https://cdn.jsdelivr.net/emojione/2.2.6/lib/js/emojione.min.js"></script>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/emojione/2.2.6/assets/css/emojione.min.css"/>

        <script src="<?= $path ?>/js/sidebar.min.js"></script>
        <link rel="stylesheet" href="<?= $path ?>/css/sidebar.min.css" type="text/css"/>

        <header id='title' class="ui secondary pointing fluid menu">

            <a class="item" id="home"><i class="fa fa-bars fa-lg"></i></a>

            <?php if ($user->group) { ?>
                <span class="tIcon mail"><a class="item" href="/my.mail.php?from=new"><span class="blink"><i class="fa fa-envelope fa-lg"></i></span></a></span>
                <span class="tIcon notification"><a class="item" href="/my.notification.php"><span class="blink"><i class="fa fa-bell fa-lg"></i></span></a></span>
                <span class="tIcon friend"><a class="item" href="/my.friends.php?act=application"><span class="blink"><i class="fa fa-user-plus fa-lg"></i></span></a></span>
            <?php } ?>

            <div class="itemtext"><?= $model->getTitle() ?></div>

            <div class="right menu">
                <?php if ($user->group) { ?>
                    <div class="ui right pointing dropdown" id="profile">
                        <a class="item dropdown-toggle" href="#" id="profile" style="padding: 0.4em 0.6em;"><img class="ui avatar image" src="<?= $user->getAvatar() ?>"></a>

                        <div class="menu">
                            <a class="active item" href="/profile.view.php"><?= __('Мой профиль') ?></a>
                            <a class="item" href="/menu.user.php"><?= __('Личное меню') ?></a>
                            <a class="item" href="/profile.edit.php"><?= __('Обновить анкету') ?></a>
                            <div class="divider"></div>
                            <a class="item" href="/modules/shop/"><b style="color: orange"><?= __('Магазин') ?></b></a>
                            <a class="item" href="/log.user_aut.php"><?= __('Журнал авторизаций') ?></a>
                            <a class="item" href="/settings.common.php"><?= __('Общие настройки') ?></a>
                            <a class="item" href="/settings.language.php"><?= __('Язык') ?></a>
                            <a class="item" href="/settings.private.php"><?= __('Приватность') ?></a>
                            <a class="item" href="/settings.themes.php"><?= __('Тема оформления') ?></a>
                            <a class="item" href="/my.avatar.php"><?= __('Обновить аватар') ?></a>
                            <a class="item" href="/my.fon.php"><?= __('Фон профиля') ?></a>
                            <div class="divider"></div>
                            <a class="item" href="/exit.php"><?= __('Выйти') ?></a>
                        </div>
                    </div>

                    <script type="text/javascript">
            $('#profile').dropdown();
                    </script>
                <?php } else { ?>
                    <a class="item" href="/login.php?return=<?= URL ?>"><i class="fa fa-sign-in fa-lg"></i></a>
                    <a class="item" href="/reg.php?return=<?= URL ?>"><i class="fa fa-user-plus fa-lg"></i></a>
                <?php } ?>
            </div>
        </header>


        <div class="ui left sidebar" style="margin-top: 50px;">
            <div class="ui vertical menu" style="border-radius: 2px;width: 260px;">
                <a class="item" href="/"><i class="fa fa-home fa-fw"></i>
                    <?= __('Главная') ?>
                </a>
            </div>
            <?php $model->displaySection('menu') ?>
        </div>
        <div class="pusher">
            <div id="container_content">
                <?php $model->displaySection('after_title') ?>

                <?php if ($model->hasTabs()) { ?>
                    <div id="tabs">
                        <?php $model->displayTabs() ?>
                    </div>
                <?php } ?>

                <?php $model->displaySection('before_content') ?>
                <div id="content">
                    <div id="messages">
                        <?php $model->displayErrors(); ?>
                        <?php $model->displayMessages(); ?>
                        <?php $model->displayInformations(); ?>      
                    </div>
                    <?php $model->displaySection('content') ?>
                </div>
                <?php $model->displaySection('after_content') ?>

                <div id="actions">
                    <?php $model->displayActions(); ?>
                    <?php $model->displayBreadcrumbs(); ?>
                </div>

                <?php $this->display('inc.foot.tpl') ?>
                <footer id="footer">
                    <?=
                    /** @var string $document_generation_time */
                    __("Время генерации страницы: %s сек", $model->getGenerationTime())
                    ?><br/>
                    <?= $copyright ?>
                </footer>
            </div>
            <script>
                $('.ui.sidebar').first()
                        .sidebar('attach events', '#home')
                        .sidebar('setting', 'transition', 'overlay')
                        ;
                $('#home')
                        .removeClass('disabled')
                        ;
            </script>
        </div>
    </body>
</html>
