<?php define('H', $_SERVER['DOCUMENT_ROOT'] . '/');
foreach (array('starting', 'worldcms') as $kernel){
	require_once H.'kernel/' . $kernel . '.php'; }

// Set the header
header("Content-type: image/png");

$text = mt_rand(10000, 99999);
// Explode the letters into separate array elements
$letters = str_split($text);

// Store the generated code into the _SESSION captcha
$_SESSION['captcha'] = $text;

// Define the Image Height & Width
$width = 100;
$height = 40;

// Create the Image
$image = imagecreate($width, $height);

// Set the background color
$black = imagecolorallocate($image, 255, 255, 255);
// Set the text color
$white = imagecolorallocate($image, 0, 0, 0);

$lg_color = mt_rand(130, 160);
$light_gray = imagecolorallocate($image, $lg_color, $lg_color, $lg_color);

// Set the font size
$font_size = 1;

// Draw background circles
for ($i = 0; $i < 1; $i++) {
    // The outside circle diameter
    $outside = 60 - $i * 20;

    // The inside circle diamater
    $inside = 59 - $i * 20;

    // Randomize the horizontal position and vertical position
    $oc = array(mt_rand(30, 40), mt_rand(10, 20));

    // Draw the outer circle
    imagefilledellipse($image, $oc[0], $oc[1], $outside, $outside, $white);

    // Draw the inner circle
    imagefilledellipse($image, $oc[0], $oc[1], $inside, $inside, $black);
}

// Generate noise
for ($noise = 0; $noise <= 15; $noise++) {
    $x = mt_rand(10, $width - 10);
    $y = mt_rand(10, $height - 10);
    imageline($image, $x, $y, $x, $y, $white);
}

function generateStars($image, $color, $repeat_x, $repeat_y)
{
    $ry = mt_rand(3, 6);
    $one_y = $ry - 2;
    $two_y = $ry - 1;
    $three_y = $ry;
    for ($x = 1; $x <= $repeat_y; $x++) {
        $one_x = $ry - 2;
        $two_x = $ry - 1;
        $three_x = $ry;
        // Generate horizontal lines
        for ($n = 1; $n <= $repeat_x; $n++) {
            imageline($image, $one_x, $one_y, $one_x, $one_y, $color);
            imageline($image, $three_x, $three_y, $three_x, $three_y, $color);
            imageline($image, $three_x, $one_y, $three_x, $one_y, $color);
            imageline($image, $one_x, $three_y, $one_x, $three_y, $color);
            imageline($image, $two_x, $two_y, $two_x, $two_y, $color);
            $one_x = $one_x + 8;
            $two_x = $two_x + 8;
            $three_x = $three_x + 8;
        }
        $one_y = $one_y + 8;
        $two_y = $two_y + 8;
        $three_y = $three_y + 8;
    }
}

generateStars($image, $light_gray, 15, 5);

// Letter position
$position = array(15, 25, 35, 45, 55, 65);

for ($m = $i = 0; $i < count($letters); $i++) {
    // Generate an rgb random value, from light gray to white
    $color = rand(0, 150);

    // Output the letters
    imagettftext($image, 20, 0, $position[$i] + $m, mt_rand(($height / 2), ($height / 2) + 15), imagecolorallocate($image, $color, $color, $color), H . 'kernel/assets/fonts/arial.ttf', $letters[$i]);
    $m += 5;
}

// Generate random vertical and horizontal lines
imageline($image, 0, mt_rand(10, $height - 10), $width, mt_rand(10, $height - 10), $light_gray);
imageline($image, mt_rand(15, $width - 15), 0, 0, mt_rand(15, $width - 15), $light_gray);

// Output the $image, don't save the file name, set quality
imagepng($image, null, 0);